/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl;

import java.lang.reflect.Field;
import org.mvel2.CompileException;
import org.mvel2.DataConversion;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.integration.VariableResolverFactory;

public class FieldAccessor
implements AccessorNode {
    private AccessorNode nextNode;
    private Field field;
    private boolean coercionRequired = false;

    public FieldAccessor() {
    }

    public FieldAccessor(Field field) {
        this.field = field;
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        try {
            if (this.nextNode != null) {
                return this.nextNode.getValue(this.field.get(ctx), elCtx, vars);
            }
            return this.field.get(ctx);
        }
        catch (Exception e) {
            throw new CompileException("unable to access field", e);
        }
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        try {
            if (this.coercionRequired) {
                value = DataConversion.convert(ctx, this.field.getClass());
                this.field.set(ctx, value);
                return value;
            }
            this.field.set(ctx, value);
            return value;
        }
        catch (IllegalArgumentException e) {
            if (!this.coercionRequired) {
                this.coercionRequired = true;
                return this.setValue(ctx, elCtx, variableFactory, value);
            }
            throw new CompileException("unable to bind property", e);
        }
        catch (Exception e) {
            throw new CompileException("unable to access field", e);
        }
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    public Class getKnownEgressType() {
        return this.field.getClass();
    }
}

