/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.conversion;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.ConversionException;
import org.mvel2.ConversionHandler;
import org.mvel2.DataConversion;
import org.mvel2.conversion.Converter;
import org.mvel2.util.ParseTools;

public class PrimArrayHandler
implements ConversionHandler {
    private final Map<Class, Converter> CNV = new HashMap<Class, Converter>();
    private final Class primitiveType;

    public PrimArrayHandler(Class type) {
        this.primitiveType = type;
        this.CNV.put(Object[].class, new Converter(){

            public Object convert(Object o) {
                return PrimArrayHandler.handleLooseTypeConversion(o.getClass(), (Object[])o, PrimArrayHandler.this.primitiveType);
            }
        });
        this.CNV.put(String[].class, new Converter(){

            public Object convert(Object o) {
                return PrimArrayHandler.handleLooseTypeConversion(o.getClass(), (String[])o, PrimArrayHandler.this.primitiveType);
            }
        });
    }

    public Object convertFrom(Object in) {
        if (!this.CNV.containsKey(in.getClass())) {
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + this.primitiveType.getName());
        }
        return this.CNV.get(in.getClass()).convert(in);
    }

    public boolean canConvertFrom(Class cls) {
        return this.CNV.containsKey(cls);
    }

    private static Object handleLooseTypeConversion(Class sourceType, Object[] input, Class targetType) {
        Class targType = ParseTools.getBaseComponentType(targetType);
        Object target = Array.newInstance(targType, input.length);
        if (input.length > 0 && DataConversion.canConvert(targetType.getComponentType(), ParseTools.getBaseComponentType(sourceType))) {
            for (int i = 0; i < input.length; ++i) {
                Array.set(target, i, DataConversion.convert(input[i], targType));
            }
        } else {
            throw new ConversionException("cannot convert to type: " + targetType.getComponentType().getName() + "[] from " + ParseTools.getBaseComponentType(sourceType).getName());
        }
        return target;
    }
}

