/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.util.List;
import org.mvel2.ast.ASTNode;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.AccessorOptimizer;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.util.CollectionParser;
import org.mvel2.util.ParseTools;

public class InlineCollectionNode
extends ASTNode {
    private Object collectionGraph;
    private char[] trailing;

    public InlineCollectionNode(char[] expr, int start, int end, int fields) {
        super(expr, start, end, fields | 0x4000);
        if ((fields & 0x10) != 0) {
            this.parseGraph(true, null);
        }
    }

    public InlineCollectionNode(char[] expr, int start, int end, int fields, Class type) {
        super(expr, start, end, fields | 0x4000);
        this.egressType = type;
        if ((fields & 0x10) != 0) {
            this.parseGraph(true, type);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.accessor != null) {
            return this.accessor.getValue(ctx, thisValue, factory);
        }
        AccessorOptimizer ao = OptimizerFactory.getThreadAccessorOptimizer();
        if (this.collectionGraph == null) {
            this.parseGraph(true, null);
        }
        this.accessor = ao.optimizeCollection(this.collectionGraph, this.egressType, this.trailing, ctx, thisValue, factory);
        this.egressType = ao.getEgressType();
        return this.accessor.getValue(ctx, thisValue, factory);
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        this.parseGraph(false, this.egressType);
        return OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE).optimizeCollection(this.collectionGraph, this.egressType, this.trailing, ctx, thisValue, factory).getValue(ctx, thisValue, factory);
    }

    private void parseGraph(boolean compile, Class type) {
        CollectionParser parser = new CollectionParser();
        this.collectionGraph = type == null ? ((List)parser.parseCollection(this.name, compile)).get(0) : ((List)parser.parseCollection(this.name, compile, type)).get(0);
        if (parser.getCursor() + 2 < this.name.length) {
            this.trailing = ParseTools.subset(this.name, parser.getCursor() + 2);
        }
        if (this.egressType == null) {
            this.egressType = this.collectionGraph.getClass();
        }
    }
}

