/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.mvel2.CompileException;
import org.mvel2.ConversionException;
import org.mvel2.DataConversion;
import org.mvel2.Unit;
import org.mvel2.debug.DebugTools;
import org.mvel2.util.InternalNumber;
import org.mvel2.util.ParseTools;
import org.mvel2.util.Soundex;

public strictfp class MathProcessor {
    private static final MathContext MATH_CONTEXT = MathContext.DECIMAL128;

    public static Object doOperations(Object val1, int operation, Object val2) {
        return MathProcessor.doOperations(val1 == null ? 0 : ParseTools.__resolveType(val1.getClass()), val1, operation, val2 == null ? -1 : ParseTools.__resolveType(val2.getClass()), val2);
    }

    public static Object doOperations(Object val1, int operation, int type2, Object val2) {
        return MathProcessor.doOperations(val1 == null ? 0 : ParseTools.__resolveType(val1.getClass()), val1, operation, type2, val2);
    }

    public static Object doOperations(int type1, Object val1, int operation, int type2, Object val2) {
        if (type1 == -1) {
            int n = type1 = val1 == null ? 0 : ParseTools.__resolveType(val1.getClass());
        }
        if (type2 == -1) {
            type2 = val2 == null ? 0 : ParseTools.__resolveType(val2.getClass());
        }
        switch (type1) {
            case 110: {
                switch (type2) {
                    case 110: {
                        return MathProcessor.doBigDecimalArithmetic((BigDecimal)val1, operation, (BigDecimal)val2, false);
                    }
                }
                if (type2 > 99) {
                    return MathProcessor.doBigDecimalArithmetic((BigDecimal)val1, operation, MathProcessor.getInternalNumberFromType(val2, type2), false);
                }
                return MathProcessor._doOperations(type1, val1, operation, type2, val2);
            }
        }
        return MathProcessor._doOperations(type1, val1, operation, type2, val2);
    }

    private static Object doBigDecimalArithmetic(BigDecimal val1, int operation, BigDecimal val2, boolean iNumber) {
        switch (operation) {
            case 0: {
                if (iNumber) {
                    return ParseTools.narrowType(val1.add(val2, MATH_CONTEXT));
                }
                return val1.add(val2, MATH_CONTEXT);
            }
            case 3: {
                if (iNumber) {
                    return ParseTools.narrowType(val1.divide(val2, MATH_CONTEXT));
                }
                return val1.divide(val2, MATH_CONTEXT);
            }
            case 1: {
                if (iNumber) {
                    return ParseTools.narrowType(val1.subtract(val2, MATH_CONTEXT));
                }
                return val1.subtract(val2, MATH_CONTEXT);
            }
            case 2: {
                if (iNumber) {
                    return ParseTools.narrowType(val1.multiply(val2, MATH_CONTEXT));
                }
                return val1.multiply(val2, MATH_CONTEXT);
            }
            case 5: {
                if (iNumber) {
                    return ParseTools.narrowType(val1.pow(val2.intValue(), MATH_CONTEXT));
                }
                return val1.pow(val2.intValue(), MATH_CONTEXT);
            }
            case 4: {
                if (iNumber) {
                    return ParseTools.narrowType(val1.remainder(val2));
                }
                return val1.remainder(val2);
            }
            case 15: {
                return val1.compareTo(val2) == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 17: {
                return val1.compareTo(val2) >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 14: {
                return val1.compareTo(val2) == -1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return val1.compareTo(val2) <= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 18: {
                return val1.compareTo(val2) == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 19: {
                return val1.compareTo(val2) != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    private static Object _doOperations(int type1, Object val1, int operation, int type2, Object val2) {
        if (operation < 20) {
            if (type1 > 99 && type1 == type2) {
                return MathProcessor.doOperationsSameType(type1, val1, operation, val2);
            }
            if (type1 > 99 && type2 > 99 || operation != 0 && ParseTools.isNumber(val1) && ParseTools.isNumber(val2)) {
                return MathProcessor.doBigDecimalArithmetic(MathProcessor.getInternalNumberFromType(val1, type1), operation, MathProcessor.getInternalNumberFromType(val2, type2), true);
            }
            if (operation != 0 && (type1 == 15 || type2 == 15) && type1 != type2 && type1 != 200 && type2 != 200) {
                return MathProcessor.doOperationNonNumeric(DataConversion.convert(val1, Boolean.class), operation, DataConversion.convert(val2, Boolean.class));
            }
            if (!(type1 != 1 && type2 != 1 || type1 != 8 && type1 != 112 && type2 != 8 && type2 != 112)) {
                if (type1 == 1) {
                    return MathProcessor.doOperationNonNumeric(val1, operation, String.valueOf(val2));
                }
                return MathProcessor.doOperationNonNumeric(String.valueOf(val1), operation, val2);
            }
        }
        return MathProcessor.doOperationNonNumeric(val1, operation, val2);
    }

    private static Object doOperationNonNumeric(Object val1, int operation, Object val2) {
        switch (operation) {
            case 0: {
                return String.valueOf(val1) + String.valueOf(val2);
            }
            case 18: {
                return MathProcessor.safeEquals(val2, val1) != false ? Boolean.TRUE : Boolean.FALSE;
            }
            case 19: {
                return MathProcessor.safeNotEquals(val2, val1) != false ? Boolean.TRUE : Boolean.FALSE;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 15: {
                if (val1 instanceof Comparable) {
                    return val2 != null && (((Comparable)val1).compareTo(val2) >= 1 ? Boolean.TRUE : Boolean.FALSE) != false;
                }
                return Boolean.FALSE;
            }
            case 17: {
                if (val1 instanceof Comparable) {
                    return val2 != null && ((Comparable)val1).compareTo(val2) >= 0 ? Boolean.TRUE : Boolean.FALSE;
                }
                return Boolean.FALSE;
            }
            case 14: {
                if (val1 instanceof Comparable) {
                    return val2 != null && ((Comparable)val1).compareTo(val2) <= -1 ? Boolean.TRUE : Boolean.FALSE;
                }
                return Boolean.FALSE;
            }
            case 16: {
                if (val1 instanceof Comparable) {
                    return val2 != null && ((Comparable)val1).compareTo(val2) <= 0 ? Boolean.TRUE : Boolean.FALSE;
                }
                return Boolean.FALSE;
            }
            case 27: {
                return Soundex.soundex(String.valueOf(val1)).equals(Soundex.soundex(String.valueOf(val2)));
            }
            case 20: {
                return String.valueOf(val1) + String.valueOf(val2);
            }
        }
        throw new CompileException("could not perform numeric operation on non-numeric types: left-type=" + (val1 != null ? val1.getClass().getName() : "null") + "; right-type=" + (val2 != null ? val2.getClass().getName() : "null") + " [vals (" + String.valueOf(val1) + ", " + String.valueOf(val2) + ") operation=" + DebugTools.getOperatorName(operation) + " (opcode:" + operation + ") ]");
    }

    private static Boolean safeEquals(Object val1, Object val2) {
        if (val1 != null) {
            return val1.equals(val2) ? Boolean.TRUE : Boolean.FALSE;
        }
        return val2 == null || (val2.equals(val1) ? Boolean.TRUE : Boolean.FALSE) != false;
    }

    private static Boolean safeNotEquals(Object val1, Object val2) {
        if (val1 != null) {
            return !val1.equals(val2) ? Boolean.TRUE : Boolean.FALSE;
        }
        return val2 != null && !val2.equals(val1) ? Boolean.TRUE : Boolean.FALSE;
    }

    private static Object doOperationsSameType(int type1, Object val1, int operation, Object val2) {
        switch (type1) {
            case 101: 
            case 106: {
                switch (operation) {
                    case 0: {
                        return (Integer)val1 + (Integer)val2;
                    }
                    case 1: {
                        return (Integer)val1 - (Integer)val2;
                    }
                    case 3: {
                        return ParseTools.narrowType(new BigDecimal((Integer)val1, MATH_CONTEXT).divide(new BigDecimal((Integer)val2), MATH_CONTEXT));
                    }
                    case 2: {
                        return (Integer)val1 * (Integer)val2;
                    }
                    case 5: {
                        double d = Math.pow(((Integer)val1).intValue(), ((Integer)val2).intValue());
                        if (d > 2.147483647E9) {
                            return d;
                        }
                        return (int)d;
                    }
                    case 4: {
                        return (Integer)val1 % (Integer)val2;
                    }
                    case 15: {
                        return (Integer)val1 > (Integer)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 17: {
                        return (Integer)val1 >= (Integer)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 14: {
                        return (Integer)val1 < (Integer)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 16: {
                        return (Integer)val1 <= (Integer)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 18: {
                        return ((Integer)val1).intValue() == ((Integer)val2).intValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 19: {
                        return ((Integer)val1).intValue() != ((Integer)val2).intValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 6: {
                        return (Integer)val1 & (Integer)val2;
                    }
                    case 7: {
                        return (Integer)val1 | (Integer)val2;
                    }
                    case 10: {
                        return (Integer)val1 << (Integer)val2;
                    }
                    case 9: {
                        return (Integer)val1 >> (Integer)val2;
                    }
                    case 11: {
                        return (Integer)val1 >>> (Integer)val2;
                    }
                    case 8: {
                        return (Integer)val1 ^ (Integer)val2;
                    }
                }
            }
            case 100: 
            case 105: {
                switch (operation) {
                    case 0: {
                        return (Short)val1 + (Short)val2;
                    }
                    case 1: {
                        return (Short)val1 - (Short)val2;
                    }
                    case 3: {
                        return ParseTools.narrowType(new InternalNumber(((Short)val1).shortValue(), MATH_CONTEXT).divide((BigDecimal)new InternalNumber(((Short)val2).shortValue()), MATH_CONTEXT));
                    }
                    case 2: {
                        return (Short)val1 * (Short)val2;
                    }
                    case 5: {
                        double d = Math.pow(((Short)val1).shortValue(), ((Short)val2).shortValue());
                        if (d > 32767.0) {
                            return d;
                        }
                        return (short)d;
                    }
                    case 4: {
                        return (Short)val1 % (Short)val2;
                    }
                    case 15: {
                        return (Short)val1 > (Short)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 17: {
                        return (Short)val1 >= (Short)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 14: {
                        return (Short)val1 < (Short)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 16: {
                        return (Short)val1 <= (Short)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 18: {
                        return ((Short)val1).shortValue() == ((Short)val2).shortValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 19: {
                        return ((Short)val1).shortValue() != ((Short)val2).shortValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 6: {
                        return (Short)val1 & (Short)val2;
                    }
                    case 7: {
                        return (Short)val1 | (Short)val2;
                    }
                    case 10: {
                        return (Short)val1 << (Short)val2;
                    }
                    case 9: {
                        return (Short)val1 >> (Short)val2;
                    }
                    case 11: {
                        return (Short)val1 >>> (Short)val2;
                    }
                    case 8: {
                        return (Short)val1 ^ (Short)val2;
                    }
                }
            }
            case 102: 
            case 107: {
                switch (operation) {
                    case 0: {
                        return (Long)val1 + (Long)val2;
                    }
                    case 1: {
                        return (Long)val1 - (Long)val2;
                    }
                    case 3: {
                        return ParseTools.narrowType(new InternalNumber((Long)val1, MATH_CONTEXT).divide((BigDecimal)new InternalNumber((Long)val2), MATH_CONTEXT));
                    }
                    case 2: {
                        return (Long)val1 * (Long)val2;
                    }
                    case 5: {
                        double d = Math.pow(((Long)val1).longValue(), ((Long)val2).longValue());
                        if (d > 9.223372036854776E18) {
                            return d;
                        }
                        return (long)d;
                    }
                    case 4: {
                        return (Long)val1 % (Long)val2;
                    }
                    case 15: {
                        return (Long)val1 > (Long)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 17: {
                        return (Long)val1 >= (Long)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 14: {
                        return (Long)val1 < (Long)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 16: {
                        return (Long)val1 <= (Long)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 18: {
                        return ((Long)val1).longValue() == ((Long)val2).longValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 19: {
                        return ((Long)val1).longValue() != ((Long)val2).longValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 6: {
                        return (Long)val1 & (Long)val2;
                    }
                    case 7: {
                        return (Long)val1 | (Long)val2;
                    }
                    case 10: {
                        return (Long)val1 << (int)((Long)val2).longValue();
                    }
                    case 12: {
                        throw new UnsupportedOperationException("unsigned left-shift not supported");
                    }
                    case 9: {
                        return (Long)val1 >> (int)((Long)val2).longValue();
                    }
                    case 11: {
                        return (Long)val1 >>> (int)((Long)val2).longValue();
                    }
                    case 8: {
                        return (Long)val1 ^ (Long)val2;
                    }
                }
            }
            case 300: {
                val2 = ((Unit)val1).convertFrom(val2);
                val1 = ((Unit)val1).getValue();
            }
            case 103: 
            case 108: {
                switch (operation) {
                    case 0: {
                        return (Double)val1 + (Double)val2;
                    }
                    case 1: {
                        return (Double)val1 - (Double)val2;
                    }
                    case 3: {
                        return ParseTools.narrowType(new InternalNumber((Double)val1, MATH_CONTEXT).divide((BigDecimal)new InternalNumber((Double)val2), MATH_CONTEXT));
                    }
                    case 2: {
                        return (Double)val1 * (Double)val2;
                    }
                    case 5: {
                        return Math.pow((Double)val1, (Double)val2);
                    }
                    case 4: {
                        return (Double)val1 % (Double)val2;
                    }
                    case 15: {
                        return (Double)val1 > (Double)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 17: {
                        return (Double)val1 >= (Double)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 14: {
                        return (Double)val1 < (Double)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 16: {
                        return (Double)val1 <= (Double)val2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 18: {
                        return ((Double)val1).doubleValue() == ((Double)val2).doubleValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 19: {
                        return ((Double)val1).doubleValue() != ((Double)val2).doubleValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        throw new CompileException("bitwise operation on a non-fixed-point number.");
                    }
                }
            }
            case 104: 
            case 109: {
                switch (operation) {
                    case 0: {
                        return Float.valueOf(((Float)val1).floatValue() + ((Float)val2).floatValue());
                    }
                    case 1: {
                        return Float.valueOf(((Float)val1).floatValue() - ((Float)val2).floatValue());
                    }
                    case 3: {
                        return ParseTools.narrowType(new InternalNumber(((Float)val1).floatValue(), MATH_CONTEXT).divide((BigDecimal)new InternalNumber(((Float)val2).floatValue()), MATH_CONTEXT));
                    }
                    case 2: {
                        return Float.valueOf(((Float)val1).floatValue() * ((Float)val2).floatValue());
                    }
                    case 5: {
                        return ParseTools.narrowType(new InternalNumber(((Float)val1).floatValue(), MATH_CONTEXT).pow(new InternalNumber(((Float)val2).floatValue()).intValue(), MATH_CONTEXT));
                    }
                    case 4: {
                        return Float.valueOf(((Float)val1).floatValue() % ((Float)val2).floatValue());
                    }
                    case 15: {
                        return ((Float)val1).floatValue() > ((Float)val2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 17: {
                        return ((Float)val1).floatValue() >= ((Float)val2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 14: {
                        return ((Float)val1).floatValue() < ((Float)val2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 16: {
                        return ((Float)val1).floatValue() <= ((Float)val2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 18: {
                        return ((Float)val1).floatValue() == ((Float)val2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 19: {
                        return ((Float)val1).floatValue() != ((Float)val2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        throw new CompileException("bitwise operation on a non-fixed-point number.");
                    }
                }
            }
            case 111: {
                switch (operation) {
                    case 0: {
                        return ((BigInteger)val1).add((BigInteger)val2);
                    }
                    case 1: {
                        return ((BigInteger)val1).subtract((BigInteger)val2);
                    }
                    case 3: {
                        return ((BigInteger)val1).divide((BigInteger)val2);
                    }
                    case 2: {
                        return ((BigInteger)val1).multiply((BigInteger)val2);
                    }
                    case 5: {
                        return ((BigInteger)val1).pow(((BigInteger)val2).intValue());
                    }
                    case 4: {
                        return ((BigInteger)val1).remainder((BigInteger)val2);
                    }
                    case 15: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) == 1 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 17: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) >= 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 14: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) == -1 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 16: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) <= 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 18: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) == 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 19: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) != 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        throw new CompileException("bitwise operation on a number greater than 32-bits not possible");
                    }
                }
            }
        }
        switch (operation) {
            case 18: {
                return MathProcessor.safeEquals(val2, val1);
            }
            case 19: {
                return MathProcessor.safeNotEquals(val2, val1);
            }
            case 0: {
                return String.valueOf(val1) + String.valueOf(val2);
            }
        }
        return null;
    }

    private static InternalNumber getInternalNumberFromType(Object in, int type) {
        if (in == null) {
            return new InternalNumber(0, MATH_CONTEXT);
        }
        switch (type) {
            case 110: {
                return new InternalNumber(((BigDecimal)in).doubleValue());
            }
            case 111: {
                return new InternalNumber((BigInteger)in, MathContext.DECIMAL128);
            }
            case 101: 
            case 106: {
                return new InternalNumber((Integer)in, MathContext.DECIMAL32);
            }
            case 102: 
            case 107: {
                return new InternalNumber((Long)in, MathContext.DECIMAL64);
            }
            case 1: {
                return new InternalNumber((String)in, MathContext.DECIMAL64);
            }
            case 104: 
            case 109: {
                return new InternalNumber(((Float)in).floatValue(), MathContext.DECIMAL64);
            }
            case 103: 
            case 108: {
                return new InternalNumber((Double)in, MathContext.DECIMAL64);
            }
            case 100: 
            case 105: {
                return new InternalNumber(((Short)in).shortValue(), MathContext.DECIMAL32);
            }
            case 8: 
            case 112: {
                return new InternalNumber(((Character)in).charValue(), MathContext.DECIMAL32);
            }
            case 7: 
            case 15: {
                return new InternalNumber((Boolean)in != false ? 1 : 0);
            }
            case 300: {
                return new InternalNumber(((Unit)in).getValue(), MathContext.DECIMAL64);
            }
        }
        throw new ConversionException("cannot convert <" + in + "> to a numeric type: " + in.getClass() + " [" + type + "]");
    }
}

