/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.compiler;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mvel2.CompileException;
import org.mvel2.ParserContext;
import org.mvel2.PropertyAccessException;
import org.mvel2.ast.Function;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.optimizers.AbstractOptimizer;
import org.mvel2.optimizers.impl.refl.nodes.WithAccessor;
import org.mvel2.util.ParseTools;
import org.mvel2.util.PropertyTools;
import org.mvel2.util.StringAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyVerifier
extends AbstractOptimizer {
    private static final int DONE = -1;
    private static final int NORM = 0;
    private static final int METH = 1;
    private static final int COL = 2;
    private static final int WITH = 3;
    private List<String> inputs = new LinkedList<String>();
    private boolean first = false;
    private boolean resolvedExternally;
    private Map<String, Class> paramTypes;
    private Class ctx = null;

    public PropertyVerifier(char[] property, ParserContext parserContext) {
        this.expr = property;
        this.length = property.length;
        this.pCtx = parserContext;
    }

    public PropertyVerifier(String property, ParserContext parserContext) {
        this.expr = property.toCharArray();
        this.length = this.expr.length;
        this.pCtx = parserContext;
    }

    public PropertyVerifier(String property, ParserContext parserContext, Class root) {
        this.expr = property.toCharArray();
        this.length = this.expr.length;
        this.pCtx = parserContext;
        this.ctx = root;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    public Class analyze() {
        this.resolvedExternally = true;
        if (this.ctx == null) {
            this.ctx = Object.class;
            this.first = true;
        }
        while (this.cursor < this.length) {
            switch (this.nextSubToken()) {
                case 0: {
                    this.ctx = this.getBeanProperty(this.ctx, this.capture());
                    break;
                }
                case 1: {
                    this.ctx = this.getMethod(this.ctx, this.capture());
                    break;
                }
                case 2: {
                    this.ctx = this.getCollectionProperty(this.ctx, this.capture());
                    break;
                }
                case 3: {
                    this.ctx = this.getWithProperty(this.ctx);
                    break;
                }
            }
            this.first = false;
        }
        return this.ctx;
    }

    private Class getBeanProperty(Class ctx, String property) {
        Member member;
        if (this.first) {
            if (this.pCtx.hasVarOrInput(property)) {
                if (this.pCtx.isStrictTypeEnforcement()) {
                    this.paramTypes = this.pCtx.getTypeParameters(property);
                    this.pCtx.setLastTypeParameters(this.pCtx.getTypeParametersAsArray(property));
                }
                return this.pCtx.getVarOrInputType(property);
            }
            if (this.pCtx.hasImport(property)) {
                this.resolvedExternally = false;
                return this.pCtx.getImport(property);
            }
            if (!this.pCtx.isStrongTyping()) {
                return Object.class;
            }
        }
        this.start = this.cursor;
        Member member2 = member = ctx != null ? PropertyTools.getFieldOrAccessor(ctx, property) : null;
        if (member instanceof Field) {
            if (this.pCtx.isStrictTypeEnforcement()) {
                Field f = (Field)member;
                if (f.getGenericType() != null && f.getGenericType() instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)f.getGenericType();
                    this.pCtx.setLastTypeParameters(pt.getActualTypeArguments());
                    Type[] gpt = pt.getActualTypeArguments();
                    TypeVariable<Class<T>>[] classArgs = ((Class)pt.getRawType()).getTypeParameters();
                    if (gpt.length > 0 && this.paramTypes == null) {
                        this.paramTypes = new HashMap<String, Class>();
                    }
                    for (int i = 0; i < gpt.length; ++i) {
                        this.paramTypes.put(classArgs[i].toString(), (Class)gpt[i]);
                    }
                }
                return f.getType();
            }
            return ((Field)member).getType();
        }
        if (member != null) {
            Type parametricReturnType;
            Method method = (Method)member;
            if (this.pCtx.isStrictTypeEnforcement() && (parametricReturnType = method.getGenericReturnType()) instanceof ParameterizedType) {
                this.pCtx.setLastTypeParameters(((ParameterizedType)parametricReturnType).getActualTypeArguments());
            }
            return method.getReturnType();
        }
        if (this.pCtx != null && this.pCtx.hasImport(property)) {
            return this.pCtx.getImport(property);
        }
        Object tryStaticMethodRef = this.tryStaticAccess();
        if (tryStaticMethodRef != null) {
            if (tryStaticMethodRef instanceof Class) {
                return (Class)tryStaticMethodRef;
            }
            if (tryStaticMethodRef instanceof Field) {
                try {
                    return ((Field)tryStaticMethodRef).get(null).getClass();
                }
                catch (Exception e) {
                    throw new CompileException("in verifier: ", e);
                }
            }
            try {
                return ((Method)tryStaticMethodRef).getReturnType();
            }
            catch (Exception e) {
                throw new CompileException("in verifier: ", e);
            }
        }
        if (ctx != null && ctx.getClass() == Class.class) {
            for (Method m : ctx.getMethods()) {
                if (!property.equals(m.getName())) continue;
                return m.getReturnType();
            }
        }
        if (this.pCtx.isStrictTypeEnforcement()) {
            this.addFatalError("unqualified type in strict mode for: " + property);
        }
        return Object.class;
    }

    private Class getCollectionProperty(Class ctx, String property) {
        if (this.first) {
            if (this.pCtx.hasVarOrInput(property)) {
                ctx = ParseTools.getSubComponentType(this.pCtx.getVarOrInputType(property));
            } else if (this.pCtx.hasImport(property)) {
                this.resolvedExternally = false;
                ctx = ParseTools.getSubComponentType(this.pCtx.getImport(property));
            } else {
                ctx = Object.class;
            }
        } else if (this.pCtx.isStrongTyping()) {
            if (Map.class.isAssignableFrom(ctx = this.getBeanProperty(ctx, property))) {
                ctx = (Class)this.pCtx.getLastTypeParameters()[1];
            } else if (Collection.class.isAssignableFrom(ctx)) {
                ctx = (Class)this.pCtx.getLastTypeParameters()[0];
            } else if (ctx.isArray()) {
                ctx = ParseTools.getBaseComponentType(ctx);
            } else {
                throw new CompileException("unknown collection type");
            }
        }
        ++this.cursor;
        this.whiteSpaceSkip();
        if (this.cursor == this.length) {
            throw new PropertyAccessException("unterminated '['");
        }
        if (this.scanTo(']')) {
            this.addFatalError("unterminated [ in token");
        }
        ++this.cursor;
        return ctx;
    }

    private Class getMethod(Class ctx, String name) {
        Class[] args;
        int st = this.cursor;
        if (this.first) {
            this.first = false;
            if (this.pCtx.hasImport(name)) {
                Method m = this.pCtx.getStaticImport(name).getMethod();
                ctx = m.getDeclaringClass();
                name = m.getName();
            } else if (this.pCtx.hasFunction(name)) {
                this.resolvedExternally = false;
                this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, '(');
                String tk = this.cursor - st > 1 ? new String(this.expr, st + 1, this.cursor - st - 1) : "";
                Function f = this.pCtx.getFunction(name);
                f.checkArgumentCount(ParseTools.parseParameterList(tk.toCharArray(), 0, -1).length);
                return f.getEgressType();
            }
        }
        String tk = (this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, '(')) - st > 1 ? new String(this.expr, st + 1, this.cursor - st - 1) : "";
        ++this.cursor;
        String[] subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
        if (subtokens.length == 0) {
            args = new Class[]{};
            subtokens = new String[]{};
        } else {
            args = new Class[subtokens.length];
            for (int i = 0; i < subtokens.length; ++i) {
                ExpressionCompiler compiler = new ExpressionCompiler(subtokens[i], true);
                compiler._compile();
                args[i] = compiler.getReturnType() != null ? compiler.getReturnType() : Object.class;
            }
        }
        Method m = ParseTools.getBestCandidate(args, name, ctx, ctx.getMethods(), this.pCtx.isStrongTyping());
        if (m == null && (m = ParseTools.getBestCandidate(args, name, ctx, ctx.getDeclaredMethods(), this.pCtx.isStrongTyping())) == null) {
            StringAppender errorBuild = new StringAppender();
            for (int i = 0; i < args.length; ++i) {
                errorBuild.append(args[i] != null ? args[i].getClass().getName() : null);
                if (i >= args.length - 1) continue;
                errorBuild.append(", ");
            }
            if ("size".equals(name) && args.length == 0 && ctx.isArray()) {
                return Integer.class;
            }
            if (this.pCtx.isStrictTypeEnforcement()) {
                this.addFatalError("unable to resolve method using strict-mode: " + ctx.getName() + "." + name + "(...)");
            }
            return Object.class;
        }
        if (this.pCtx.isStrictTypeEnforcement() && m.getGenericReturnType() != null) {
            LinkedHashMap<String, Class> typeArgs = new LinkedHashMap<String, Class>();
            Type[] gpt = m.getGenericParameterTypes();
            for (int i = 0; i < gpt.length; ++i) {
                if (!(gpt[i] instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)gpt[i];
                Class z = this.pCtx.getImport(subtokens[i]);
                if (z == null) continue;
                if (pt.getRawType().equals(Class.class)) {
                    typeArgs.put(pt.getActualTypeArguments()[0].toString(), z);
                    continue;
                }
                typeArgs.put(gpt[i].toString(), z);
            }
            Type parametricReturnType = m.getGenericReturnType();
            String returnTypeArg = parametricReturnType.toString();
            if (parametricReturnType instanceof ParameterizedType) {
                this.pCtx.setLastTypeParameters(((ParameterizedType)parametricReturnType).getActualTypeArguments());
            }
            if (this.paramTypes != null && this.paramTypes.containsKey(returnTypeArg)) {
                return this.paramTypes.get(returnTypeArg);
            }
            if (typeArgs.containsKey(returnTypeArg)) {
                return (Class)typeArgs.get(returnTypeArg);
            }
        }
        return m.getReturnType();
    }

    private Class getWithProperty(Class ctx) {
        String root = new String(this.expr, 0, this.cursor - 1).trim();
        int start = this.cursor + 1;
        this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, '{', this.pCtx);
        int n = this.cursor++;
        new WithAccessor(root, ParseTools.subset(this.expr, start, n - start), ctx, this.pCtx.isStrictTypeEnforcement());
        return ctx;
    }

    public boolean isResolvedExternally() {
        return this.resolvedExternally;
    }

    public Class getCtx() {
        return this.ctx;
    }

    public void setCtx(Class ctx) {
        this.ctx = ctx;
    }
}

