/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.integration.impl;

import java.util.Map;
import org.mvel2.CompileException;
import org.mvel2.DataConversion;
import org.mvel2.integration.VariableResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapVariableResolver
implements VariableResolver {
    private String name;
    private Class<?> knownType;
    private Map<String, Object> variableMap;
    private boolean cache = false;

    public MapVariableResolver(Map<String, Object> variableMap, String name) {
        this.variableMap = variableMap;
        this.name = name;
    }

    public MapVariableResolver(Map variableMap, String name, Class knownType) {
        this.name = name;
        this.knownType = knownType;
        this.variableMap = variableMap;
    }

    public MapVariableResolver(Map<String, Object> variableMap, String name, boolean cache) {
        this.variableMap = variableMap;
        this.name = name;
        this.cache = cache;
    }

    public MapVariableResolver(Map<String, Object> variableMap, String name, Class knownType, boolean cache) {
        this.name = name;
        this.knownType = knownType;
        this.variableMap = variableMap;
        this.cache = cache;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setStaticType(Class knownType) {
        this.knownType = knownType;
    }

    public void setVariableMap(Map variableMap) {
        this.variableMap = variableMap;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class getType() {
        return this.knownType;
    }

    @Override
    public void setValue(Object value) {
        if (this.knownType != null && value != null && value.getClass() != this.knownType) {
            Class<?> t = value.getClass();
            if (!DataConversion.canConvert(this.knownType, t)) {
                throw new CompileException("cannot assign " + value.getClass().getName() + " to type: " + this.knownType.getName());
            }
            try {
                value = DataConversion.convert(value, this.knownType);
            }
            catch (Exception e) {
                throw new CompileException("cannot convert value of " + value.getClass().getName() + " to: " + this.knownType.getName());
            }
        }
        this.variableMap.put(this.name, value);
    }

    @Override
    public Object getValue() {
        return this.variableMap.get(this.name);
    }

    @Override
    public int getFlags() {
        return 0;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }
}

