/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.Assignment;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ParseTools;

public class TypedVarNode
extends ASTNode
implements Assignment {
    private String name;
    private char[] stmt;
    private ExecutableStatement statement;

    public TypedVarNode(String name, Class type) {
        this.name = name;
        this.egressType = type;
    }

    public TypedVarNode(char[] expr, int fields, Class type, ParserContext pCtx) {
        this.egressType = type;
        this.fields = fields;
        ((ASTNode)this).name = expr;
        int assignStart = ParseTools.find(expr, '=');
        if (assignStart != -1) {
            this.name = ParseTools.createStringTrimmed(expr, 0, assignStart);
            ParseTools.checkNameSafety(this.name);
            if (((fields |= 0x400) & 0x10) != 0) {
                this.stmt = ParseTools.subset(expr, assignStart + 1);
                this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt);
            } else {
                this.stmt = ParseTools.subset(expr, assignStart + 1);
            }
        } else {
            this.name = new String(expr);
            ParseTools.checkNameSafety(this.name);
        }
        if ((fields & 0x10) != 0) {
            pCtx.addVariable(this.name, this.egressType, true);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.statement == null) {
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt);
        }
        ctx = this.statement.getValue(ctx, thisValue, factory);
        factory.createVariable(this.name, ctx, this.egressType);
        return ctx;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ctx = MVEL.eval(this.stmt, thisValue, factory);
        factory.createVariable(this.name, ctx, this.egressType);
        return ctx;
    }

    public String getName() {
        return this.name;
    }

    public String getAssignmentVar() {
        return this.name;
    }

    public char[] getExpression() {
        return this.stmt;
    }

    public boolean isNewDeclaration() {
        return true;
    }

    public void setValueStatement(ExecutableStatement stmt) {
        this.statement = stmt;
    }
}

