/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import org.mvel2.CompileException;
import org.mvel2.ast.ASTNode;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ParseTools;

public class ImportNode
extends ASTNode {
    private Class importClass;
    private boolean packageImport;
    private short offset;
    private static final char[] WC_TEST = new char[]{'.', '*'};

    public ImportNode(char[] expr) {
        this.name = expr;
        if (ParseTools.endsWith(expr, WC_TEST)) {
            this.packageImport = true;
            this.offset = (short)ParseTools.findLast(expr, '.');
        } else {
            try {
                this.importClass = Class.forName(new String(expr), true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new CompileException("class not found: " + new String(expr));
            }
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (!this.packageImport) {
            return ParseTools.findClassImportResolverFactory(factory).addClass(this.importClass);
        }
        ParseTools.findClassImportResolverFactory(factory).addPackageImport(new String(this.name, 0, (int)this.offset));
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }

    public Class getImportClass() {
        return this.importClass;
    }

    public boolean isPackageImport() {
        return this.packageImport;
    }

    public void setPackageImport(boolean packageImport) {
        this.packageImport = packageImport;
    }

    public String getPackageImport() {
        return new String(this.name, 0, (int)this.offset);
    }
}

