/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.util.HashMap;
import org.mvel2.CompileException;
import org.mvel2.ParserContext;
import org.mvel2.ast.BlockNode;
import org.mvel2.ast.RedundantCodeException;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.util.CompilerTools;
import org.mvel2.util.ParseTools;

public class ForNode
extends BlockNode {
    protected String item;
    protected ExecutableStatement initializer;
    protected ExecutableStatement condition;
    protected ExecutableStatement after;

    public ForNode(char[] condition, char[] block, int fields, ParserContext pCtx) {
        this.name = condition;
        boolean varsEscape = this.handleCond(condition, fields, pCtx);
        this.block = block;
        this.compiledBlock = (ExecutableStatement)ParseTools.subCompileExpression(block, pCtx);
        if ((fields & 0x10) != 0 && this.compiledBlock.isEmptyStatement() && !varsEscape) {
            throw new RedundantCodeException();
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        MapVariableResolverFactory ctxFactory = new MapVariableResolverFactory(new HashMap<String, Object>(0), factory);
        this.initializer.getValue(ctx, thisValue, ctxFactory);
        while (((Boolean)this.condition.getValue(ctx, thisValue, ctxFactory)).booleanValue()) {
            this.compiledBlock.getValue(ctx, thisValue, ctxFactory);
            this.after.getValue(ctx, thisValue, ctxFactory);
        }
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        factory = new MapVariableResolverFactory(new HashMap<String, Object>(0), factory);
        this.initializer.getValue(ctx, thisValue, factory);
        while (((Boolean)this.condition.getValue(ctx, thisValue, factory)).booleanValue()) {
            this.compiledBlock.getValue(ctx, thisValue, factory);
            this.after.getValue(ctx, thisValue, factory);
        }
        return null;
    }

    public ForNode() {
    }

    private boolean handleCond(char[] condition, int fields, ParserContext pCtx) {
        int start = 0;
        int cursor = ForNode.nextCondPart(condition, start, false);
        try {
            if (pCtx != null && (fields & 0x10) != 0) {
                pCtx = pCtx.createSubcontext().createColoringSubcontext();
            }
            this.initializer = (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.subset(condition, start, cursor - start - 1), pCtx);
            start = cursor;
            cursor = ForNode.nextCondPart(condition, start, false);
            this.condition = (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.subset(condition, start, cursor - start - 1), pCtx);
            CompilerTools.expectType(this.condition, Boolean.class, (fields & 0x10) != 0);
            start = cursor;
            this.after = (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.subset(condition, start, ForNode.nextCondPart(condition, start, true) - start), pCtx);
            if (pCtx != null && (fields & 0x10) != 0 && pCtx.isVariablesEscape()) {
                return true;
            }
        }
        catch (NegativeArraySizeException e) {
            throw new CompileException("wrong syntax; did you mean to use 'foreach'?");
        }
        return false;
    }

    private static int nextCondPart(char[] condition, int cursor, boolean allowEnd) {
        while (cursor < condition.length) {
            if (condition[cursor] == ';') {
                return ++cursor;
            }
            ++cursor;
        }
        if (!allowEnd) {
            throw new CompileException("expected ;");
        }
        return cursor;
    }
}

