/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.dynamic;

import org.mvel2.ParserContext;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.compiler.Accessor;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.optimizers.dynamic.DynamicAccessor;
import org.mvel2.optimizers.dynamic.DynamicOptimizer;

public class DynamicCollectionAccessor
implements DynamicAccessor {
    private Object rootObject;
    private Class colType;
    private char[] property;
    private long stamp;
    private int type;
    private int runcount;
    private boolean opt = false;
    private Accessor _safeAccessor;
    private Accessor _accessor;

    public DynamicCollectionAccessor(Object rootObject, Class colType, char[] property, int type, Accessor _accessor) {
        this.rootObject = rootObject;
        this.colType = colType;
        this._safeAccessor = this._accessor = _accessor;
        this.type = type;
        this.property = property;
        this.stamp = System.currentTimeMillis();
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        if (!this.opt && ++this.runcount > DynamicOptimizer.tenuringThreshold) {
            if (System.currentTimeMillis() - this.stamp < DynamicOptimizer.timeSpan) {
                this.opt = true;
                return this.optimize(AbstractParser.getCurrentThreadParserContext(), ctx, elCtx, variableFactory);
            }
            this.runcount = 0;
            this.stamp = System.currentTimeMillis();
        }
        return this._accessor.getValue(ctx, elCtx, variableFactory);
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        ++this.runcount;
        return this._accessor.setValue(ctx, elCtx, variableFactory, value);
    }

    private Object optimize(ParserContext pCtx, Object ctx, Object elCtx, VariableResolverFactory variableResolverFactory) {
        if (DynamicOptimizer.classLoader.isOverloaded()) {
            DynamicOptimizer.enforceTenureLimit();
        }
        this._accessor = OptimizerFactory.getAccessorCompiler("ASM").optimizeCollection(pCtx, this.rootObject, this.colType, this.property, ctx, elCtx, variableResolverFactory);
        return this._accessor.getValue(ctx, elCtx, variableResolverFactory);
    }

    public void deoptimize() {
        this._accessor = this._safeAccessor;
        this.opt = false;
        this.runcount = 0;
        this.stamp = System.currentTimeMillis();
    }

    public long getStamp() {
        return this.stamp;
    }

    public int getRuncount() {
        return this.runcount;
    }

    public Class getKnownEgressType() {
        return this.colType;
    }
}

