/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta.transactions;

import java.util.concurrent.atomic.AtomicLong;
import org.multiverse.api.IsolationLevel;
import org.multiverse.api.blocking.DefaultRetryLatch;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.api.exceptions.SpeculativeConfigurationError;
import org.multiverse.api.exceptions.TodoException;
import org.multiverse.api.functions.BooleanFunction;
import org.multiverse.api.functions.DoubleFunction;
import org.multiverse.api.functions.Function;
import org.multiverse.api.functions.IntFunction;
import org.multiverse.api.functions.LongFunction;
import org.multiverse.stms.beta.BetaStm;
import org.multiverse.stms.beta.Listeners;
import org.multiverse.stms.beta.conflictcounters.LocalConflictCounter;
import org.multiverse.stms.beta.transactionalobjects.BetaBooleanRef;
import org.multiverse.stms.beta.transactionalobjects.BetaBooleanRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaDoubleRef;
import org.multiverse.stms.beta.transactionalobjects.BetaDoubleRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaIntRef;
import org.multiverse.stms.beta.transactionalobjects.BetaIntRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaLongRef;
import org.multiverse.stms.beta.transactionalobjects.BetaLongRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaRef;
import org.multiverse.stms.beta.transactionalobjects.BetaRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaTransactionalObject;
import org.multiverse.stms.beta.transactions.AbstractLeanBetaTransaction;
import org.multiverse.stms.beta.transactions.BetaTransaction;
import org.multiverse.stms.beta.transactions.BetaTransactionConfiguration;

public final class LeanArrayBetaTransaction
extends AbstractLeanBetaTransaction {
    public static final AtomicLong conflictScan = new AtomicLong();
    private final BetaTranlocal[] array;
    private LocalConflictCounter localConflictCounter;
    private int firstFreeIndex = 0;
    private boolean hasReads;
    private boolean hasUntrackedReads;

    public LeanArrayBetaTransaction(BetaStm stm) {
        this(new BetaTransactionConfiguration(stm).init());
    }

    public LeanArrayBetaTransaction(BetaTransactionConfiguration config) {
        super(2, config);
        this.localConflictCounter = config.globalConflictCounter.createLocalConflictCounter();
        this.array = new BetaTranlocal[config.maxArrayTransactionSize];
        this.remainingTimeoutNs = config.timeoutNs;
    }

    @Override
    public final LocalConflictCounter getLocalConflictCounter() {
        return this.localConflictCounter;
    }

    @Override
    public void ensureWrites() {
        if (this.status != 1) {
            throw this.abortEnsureWrites();
        }
        if (this.config.writeLockMode != 0) {
            return;
        }
        if (this.firstFreeIndex == 0) {
            return;
        }
        int spinCount = this.config.spinCount;
        for (int k = 0; k < this.firstFreeIndex; ++k) {
            BetaTranlocal tranlocal = this.array[k];
            if (tranlocal.isReadonly() || tranlocal.owner.___tryLockAndCheckConflict(this, spinCount, tranlocal, false)) continue;
            throw this.abortOnReadConflict();
        }
    }

    @Override
    public final boolean tryLock(BetaTransactionalObject ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortTryLock(ref);
        }
        if (ref == null) {
            throw this.abortTryLockWhenNullReference(ref);
        }
        lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        throw new TodoException();
    }

    @Override
    public final <E> E read(BetaRef<E> ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        int index = this.indexOf(ref);
        if (index != -1) {
            BetaRefTranlocal tranlocal = (BetaRefTranlocal)this.array[index];
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted || this.config.readLockMode != 0) {
            if (this.firstFreeIndex == this.array.length) {
                throw this.abortOnTooSmallSize(this.array.length + 1);
            }
            BetaRefTranlocal tranlocal = this.pool.take(ref);
            tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
            tranlocal.tx = this;
            this.array[this.firstFreeIndex] = tranlocal;
            ++this.firstFreeIndex;
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        this.hasUntrackedReads = true;
        return ref.atomicWeakGet();
    }

    @Override
    public final <E> BetaRefTranlocal<E> open(BetaRef<E> ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        int index = this.indexOf(ref);
        if (index != -1) {
            return (BetaRefTranlocal)this.array[index];
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        BetaRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        tranlocal.tx = this;
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public <E> BetaRefTranlocal<E> openForRead(BetaRef<E> ref, int lockMode) {
        BetaRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (ref == null) {
            return null;
        }
        lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        int index = this.indexOf(ref);
        if (index > -1) {
            BetaRefTranlocal tranlocal2 = (BetaRefTranlocal)this.array[index];
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = tranlocal2;
            }
            if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal2;
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            ref.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        if (lockMode != 0 || this.config.trackReads || tranlocal.hasDepartObligation()) {
            this.array[this.firstFreeIndex] = tranlocal;
            ++this.firstFreeIndex;
        } else {
            this.hasUntrackedReads = true;
        }
        return tranlocal;
    }

    @Override
    public <E> BetaRefTranlocal<E> openForWrite(BetaRef<E> ref, int lockMode) {
        BetaRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        int index = this.indexOf(ref);
        if (index != -1) {
            BetaRefTranlocal tranlocal2 = (BetaRefTranlocal)this.array[index];
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = tranlocal2;
            }
            if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            if (tranlocal2.isReadonly()) {
                this.hasUpdates = true;
                tranlocal2.setStatus(2);
            }
            return tranlocal2;
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(2);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        this.hasUpdates = true;
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public final <E> BetaRefTranlocal<E> openForConstruction(BetaRef<E> ref) {
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        int index = this.indexOf(ref);
        if (index >= 0) {
            BetaRefTranlocal result = (BetaRefTranlocal)this.array[index];
            if (!result.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = result;
            }
            return result;
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        BetaRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        tranlocal.setDirty(true);
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public <E> void commute(BetaRef<E> ref, Function<E> function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        this.config.needsCommute();
        this.abort();
        throw SpeculativeConfigurationError.INSTANCE;
    }

    @Override
    public final int read(BetaIntRef ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        int index = this.indexOf(ref);
        if (index != -1) {
            BetaIntRefTranlocal tranlocal = (BetaIntRefTranlocal)this.array[index];
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted || this.config.readLockMode != 0) {
            if (this.firstFreeIndex == this.array.length) {
                throw this.abortOnTooSmallSize(this.array.length + 1);
            }
            BetaIntRefTranlocal tranlocal = this.pool.take(ref);
            tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
            tranlocal.tx = this;
            this.array[this.firstFreeIndex] = tranlocal;
            ++this.firstFreeIndex;
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        this.hasUntrackedReads = true;
        return ref.atomicWeakGet();
    }

    @Override
    public final BetaIntRefTranlocal open(BetaIntRef ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        int index = this.indexOf(ref);
        if (index != -1) {
            return (BetaIntRefTranlocal)this.array[index];
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        BetaIntRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        tranlocal.tx = this;
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public BetaIntRefTranlocal openForRead(BetaIntRef ref, int lockMode) {
        BetaIntRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (ref == null) {
            return null;
        }
        lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        int index = this.indexOf(ref);
        if (index > -1) {
            BetaIntRefTranlocal tranlocal2 = (BetaIntRefTranlocal)this.array[index];
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = tranlocal2;
            }
            if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal2;
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            ref.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        if (lockMode != 0 || this.config.trackReads || tranlocal.hasDepartObligation()) {
            this.array[this.firstFreeIndex] = tranlocal;
            ++this.firstFreeIndex;
        } else {
            this.hasUntrackedReads = true;
        }
        return tranlocal;
    }

    @Override
    public BetaIntRefTranlocal openForWrite(BetaIntRef ref, int lockMode) {
        BetaIntRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        int index = this.indexOf(ref);
        if (index != -1) {
            BetaIntRefTranlocal tranlocal2 = (BetaIntRefTranlocal)this.array[index];
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = tranlocal2;
            }
            if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            if (tranlocal2.isReadonly()) {
                this.hasUpdates = true;
                tranlocal2.setStatus(2);
            }
            return tranlocal2;
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(2);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        this.hasUpdates = true;
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public final BetaIntRefTranlocal openForConstruction(BetaIntRef ref) {
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        int index = this.indexOf(ref);
        if (index >= 0) {
            BetaIntRefTranlocal result = (BetaIntRefTranlocal)this.array[index];
            if (!result.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = result;
            }
            return result;
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        BetaIntRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        tranlocal.setDirty(true);
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public void commute(BetaIntRef ref, IntFunction function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        this.config.needsCommute();
        this.abort();
        throw SpeculativeConfigurationError.INSTANCE;
    }

    @Override
    public final boolean read(BetaBooleanRef ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        int index = this.indexOf(ref);
        if (index != -1) {
            BetaBooleanRefTranlocal tranlocal = (BetaBooleanRefTranlocal)this.array[index];
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted || this.config.readLockMode != 0) {
            if (this.firstFreeIndex == this.array.length) {
                throw this.abortOnTooSmallSize(this.array.length + 1);
            }
            BetaBooleanRefTranlocal tranlocal = this.pool.take(ref);
            tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
            tranlocal.tx = this;
            this.array[this.firstFreeIndex] = tranlocal;
            ++this.firstFreeIndex;
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        this.hasUntrackedReads = true;
        return ref.atomicWeakGet();
    }

    @Override
    public final BetaBooleanRefTranlocal open(BetaBooleanRef ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        int index = this.indexOf(ref);
        if (index != -1) {
            return (BetaBooleanRefTranlocal)this.array[index];
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        BetaBooleanRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        tranlocal.tx = this;
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public BetaBooleanRefTranlocal openForRead(BetaBooleanRef ref, int lockMode) {
        BetaBooleanRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (ref == null) {
            return null;
        }
        lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        int index = this.indexOf(ref);
        if (index > -1) {
            BetaBooleanRefTranlocal tranlocal2 = (BetaBooleanRefTranlocal)this.array[index];
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = tranlocal2;
            }
            if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal2;
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            ref.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        if (lockMode != 0 || this.config.trackReads || tranlocal.hasDepartObligation()) {
            this.array[this.firstFreeIndex] = tranlocal;
            ++this.firstFreeIndex;
        } else {
            this.hasUntrackedReads = true;
        }
        return tranlocal;
    }

    @Override
    public BetaBooleanRefTranlocal openForWrite(BetaBooleanRef ref, int lockMode) {
        BetaBooleanRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        int index = this.indexOf(ref);
        if (index != -1) {
            BetaBooleanRefTranlocal tranlocal2 = (BetaBooleanRefTranlocal)this.array[index];
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = tranlocal2;
            }
            if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            if (tranlocal2.isReadonly()) {
                this.hasUpdates = true;
                tranlocal2.setStatus(2);
            }
            return tranlocal2;
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(2);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        this.hasUpdates = true;
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public final BetaBooleanRefTranlocal openForConstruction(BetaBooleanRef ref) {
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        int index = this.indexOf(ref);
        if (index >= 0) {
            BetaBooleanRefTranlocal result = (BetaBooleanRefTranlocal)this.array[index];
            if (!result.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = result;
            }
            return result;
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        BetaBooleanRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        tranlocal.setDirty(true);
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public void commute(BetaBooleanRef ref, BooleanFunction function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        this.config.needsCommute();
        this.abort();
        throw SpeculativeConfigurationError.INSTANCE;
    }

    @Override
    public final double read(BetaDoubleRef ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        int index = this.indexOf(ref);
        if (index != -1) {
            BetaDoubleRefTranlocal tranlocal = (BetaDoubleRefTranlocal)this.array[index];
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted || this.config.readLockMode != 0) {
            if (this.firstFreeIndex == this.array.length) {
                throw this.abortOnTooSmallSize(this.array.length + 1);
            }
            BetaDoubleRefTranlocal tranlocal = this.pool.take(ref);
            tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
            tranlocal.tx = this;
            this.array[this.firstFreeIndex] = tranlocal;
            ++this.firstFreeIndex;
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        this.hasUntrackedReads = true;
        return ref.atomicWeakGet();
    }

    @Override
    public final BetaDoubleRefTranlocal open(BetaDoubleRef ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        int index = this.indexOf(ref);
        if (index != -1) {
            return (BetaDoubleRefTranlocal)this.array[index];
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        BetaDoubleRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        tranlocal.tx = this;
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public BetaDoubleRefTranlocal openForRead(BetaDoubleRef ref, int lockMode) {
        BetaDoubleRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (ref == null) {
            return null;
        }
        lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        int index = this.indexOf(ref);
        if (index > -1) {
            BetaDoubleRefTranlocal tranlocal2 = (BetaDoubleRefTranlocal)this.array[index];
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = tranlocal2;
            }
            if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal2;
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            ref.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        if (lockMode != 0 || this.config.trackReads || tranlocal.hasDepartObligation()) {
            this.array[this.firstFreeIndex] = tranlocal;
            ++this.firstFreeIndex;
        } else {
            this.hasUntrackedReads = true;
        }
        return tranlocal;
    }

    @Override
    public BetaDoubleRefTranlocal openForWrite(BetaDoubleRef ref, int lockMode) {
        BetaDoubleRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        int index = this.indexOf(ref);
        if (index != -1) {
            BetaDoubleRefTranlocal tranlocal2 = (BetaDoubleRefTranlocal)this.array[index];
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = tranlocal2;
            }
            if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            if (tranlocal2.isReadonly()) {
                this.hasUpdates = true;
                tranlocal2.setStatus(2);
            }
            return tranlocal2;
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(2);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        this.hasUpdates = true;
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public final BetaDoubleRefTranlocal openForConstruction(BetaDoubleRef ref) {
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        int index = this.indexOf(ref);
        if (index >= 0) {
            BetaDoubleRefTranlocal result = (BetaDoubleRefTranlocal)this.array[index];
            if (!result.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = result;
            }
            return result;
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        BetaDoubleRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        tranlocal.setDirty(true);
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public void commute(BetaDoubleRef ref, DoubleFunction function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        this.config.needsCommute();
        this.abort();
        throw SpeculativeConfigurationError.INSTANCE;
    }

    @Override
    public final long read(BetaLongRef ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        int index = this.indexOf(ref);
        if (index != -1) {
            BetaLongRefTranlocal tranlocal = (BetaLongRefTranlocal)this.array[index];
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted || this.config.readLockMode != 0) {
            if (this.firstFreeIndex == this.array.length) {
                throw this.abortOnTooSmallSize(this.array.length + 1);
            }
            BetaLongRefTranlocal tranlocal = this.pool.take(ref);
            tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
            tranlocal.tx = this;
            this.array[this.firstFreeIndex] = tranlocal;
            ++this.firstFreeIndex;
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        this.hasUntrackedReads = true;
        return ref.atomicWeakGet();
    }

    @Override
    public final BetaLongRefTranlocal open(BetaLongRef ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        int index = this.indexOf(ref);
        if (index != -1) {
            return (BetaLongRefTranlocal)this.array[index];
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        BetaLongRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        tranlocal.tx = this;
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public BetaLongRefTranlocal openForRead(BetaLongRef ref, int lockMode) {
        BetaLongRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (ref == null) {
            return null;
        }
        lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        int index = this.indexOf(ref);
        if (index > -1) {
            BetaLongRefTranlocal tranlocal2 = (BetaLongRefTranlocal)this.array[index];
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = tranlocal2;
            }
            if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal2;
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            ref.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        if (lockMode != 0 || this.config.trackReads || tranlocal.hasDepartObligation()) {
            this.array[this.firstFreeIndex] = tranlocal;
            ++this.firstFreeIndex;
        } else {
            this.hasUntrackedReads = true;
        }
        return tranlocal;
    }

    @Override
    public BetaLongRefTranlocal openForWrite(BetaLongRef ref, int lockMode) {
        BetaLongRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        int index = this.indexOf(ref);
        if (index != -1) {
            BetaLongRefTranlocal tranlocal2 = (BetaLongRefTranlocal)this.array[index];
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = tranlocal2;
            }
            if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            if (tranlocal2.isReadonly()) {
                this.hasUpdates = true;
                tranlocal2.setStatus(2);
            }
            return tranlocal2;
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(2);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        this.hasUpdates = true;
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public final BetaLongRefTranlocal openForConstruction(BetaLongRef ref) {
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        int index = this.indexOf(ref);
        if (index >= 0) {
            BetaLongRefTranlocal result = (BetaLongRefTranlocal)this.array[index];
            if (!result.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = result;
            }
            return result;
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        BetaLongRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        tranlocal.setDirty(true);
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public void commute(BetaLongRef ref, LongFunction function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        this.config.needsCommute();
        this.abort();
        throw SpeculativeConfigurationError.INSTANCE;
    }

    @Override
    public final BetaTranlocal open(BetaTransactionalObject ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.getStm() != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        int index = this.indexOf(ref);
        if (index != -1) {
            return this.array[index];
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        BetaTranlocal tranlocal = this.pool.take(ref);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        tranlocal.tx = this;
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public BetaTranlocal openForRead(BetaTransactionalObject ref, int lockMode) {
        BetaTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (ref == null) {
            return null;
        }
        lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        int index = this.indexOf(ref);
        if (index > -1) {
            BetaTranlocal tranlocal2 = this.array[index];
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = tranlocal2;
            }
            if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal2;
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            ref.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        if (lockMode != 0 || this.config.trackReads || tranlocal.hasDepartObligation()) {
            this.array[this.firstFreeIndex] = tranlocal;
            ++this.firstFreeIndex;
        } else {
            this.hasUntrackedReads = true;
        }
        return tranlocal;
    }

    @Override
    public BetaTranlocal openForWrite(BetaTransactionalObject ref, int lockMode) {
        BetaTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        int index = this.indexOf(ref);
        if (index != -1) {
            BetaTranlocal tranlocal2 = this.array[index];
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = tranlocal2;
            }
            if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            if (tranlocal2.isReadonly()) {
                this.hasUpdates = true;
                tranlocal2.setStatus(2);
            }
            return tranlocal2;
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(2);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        this.hasUpdates = true;
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public final BetaTranlocal openForConstruction(BetaTransactionalObject ref) {
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        int index = this.indexOf(ref);
        if (index >= 0) {
            BetaTranlocal result = this.array[index];
            if (!result.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            if (index > 0) {
                this.array[index] = this.array[0];
                this.array[0] = result;
            }
            return result;
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        if (this.firstFreeIndex == this.array.length) {
            throw this.abortOnTooSmallSize(this.array.length + 1);
        }
        BetaTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        tranlocal.setDirty(true);
        this.array[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
        return tranlocal;
    }

    @Override
    public void commute(BetaTransactionalObject ref, Function function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        this.config.needsCommute();
        this.abort();
        throw SpeculativeConfigurationError.INSTANCE;
    }

    @Override
    public BetaTranlocal get(BetaTransactionalObject owner) {
        int indexOf = this.indexOf(owner);
        return indexOf == -1 ? null : this.array[indexOf];
    }

    @Override
    public BetaTranlocal locate(BetaTransactionalObject owner) {
        if (this.status != 1) {
            throw this.abortLocate(owner);
        }
        if (owner == null) {
            throw this.abortLocateWhenNullReference();
        }
        int indexOf = this.indexOf(owner);
        return indexOf == -1 ? null : this.array[indexOf];
    }

    private int indexOf(BetaTransactionalObject owner) {
        assert (owner != null);
        for (int k = 0; k < this.firstFreeIndex; ++k) {
            BetaTranlocal tranlocal = this.array[k];
            if (tranlocal.owner != owner) continue;
            return k;
        }
        return -1;
    }

    private boolean hasReadConflict() {
        if (this.config.readLockMode != 0 || this.config.inconsistentReadAllowed) {
            return false;
        }
        if (this.hasUntrackedReads) {
            return this.localConflictCounter.syncAndCheckConflict();
        }
        if (this.firstFreeIndex == 0) {
            return false;
        }
        if (!this.localConflictCounter.syncAndCheckConflict()) {
            return false;
        }
        for (int k = 0; k < this.firstFreeIndex; ++k) {
            BetaTranlocal tranlocal = this.array[k];
            if (!tranlocal.owner.___hasReadConflict(tranlocal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void abort() {
        switch (this.status) {
            case 1: 
            case 2: {
                this.status = 3;
                for (int k = 0; k < this.firstFreeIndex; ++k) {
                    BetaTranlocal tranlocal = this.array[k];
                    this.array[k] = null;
                    tranlocal.owner.___abort(this, tranlocal, this.pool);
                }
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                throw new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.abort, reason: the transaction already is committed", this.config.familyName));
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public final void commit() {
        if (this.status != 1 && this.status != 2) {
            switch (this.status) {
                case 3: {
                    throw new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.commit, reason:the transaction already is aborted", this.config.familyName));
                }
                case 4: {
                    return;
                }
            }
            throw new IllegalStateException();
        }
        if (this.abortOnly) {
            throw this.abortOnWriteConflict();
        }
        Listeners[] listeners = null;
        if (this.firstFreeIndex > 0) {
            boolean needsPrepare;
            boolean bl = needsPrepare = this.status == 1 && this.hasUpdates && this.config.readLockMode != 2;
            if (this.config.dirtyCheck) {
                if (needsPrepare && !this.doPrepareDirty()) {
                    throw this.abortOnWriteConflict();
                }
                listeners = this.commitDirty();
            } else {
                if (needsPrepare && !this.doPrepareAll()) {
                    throw this.abortOnWriteConflict();
                }
                listeners = this.commitAll();
            }
        }
        this.status = 4;
        if (listeners != null) {
            Listeners.openAll(listeners, this.pool);
        }
    }

    private Listeners[] commitAll() {
        Listeners[] listenersArray = null;
        int listenersArrayIndex = 0;
        for (int k = 0; k < this.firstFreeIndex; ++k) {
            BetaTranlocal tranlocal = this.array[k];
            this.array[k] = null;
            Listeners listeners = tranlocal.owner.___commitAll(tranlocal, this, this.pool);
            if (listeners == null) continue;
            if (listenersArray == null) {
                int length = this.firstFreeIndex - k;
                listenersArray = this.pool.takeListenersArray(length);
            }
            listenersArray[listenersArrayIndex] = listeners;
            ++listenersArrayIndex;
        }
        return listenersArray;
    }

    private Listeners[] commitDirty() {
        Listeners[] listenersArray = null;
        int listenersArrayIndex = 0;
        for (int k = 0; k < this.firstFreeIndex; ++k) {
            Listeners listeners;
            BetaTranlocal tranlocal = this.array[k];
            this.array[k] = null;
            if (!tranlocal.isReadonly() && !tranlocal.isDirty()) {
                tranlocal.calculateIsDirty();
            }
            if ((listeners = tranlocal.owner.___commitDirty(tranlocal, this, this.pool)) == null) continue;
            if (listenersArray == null) {
                int length = this.firstFreeIndex - k;
                listenersArray = this.pool.takeListenersArray(length);
            }
            listenersArray[listenersArrayIndex] = listeners;
            ++listenersArrayIndex;
        }
        return listenersArray;
    }

    @Override
    public void prepare() {
        if (this.status != 1) {
            switch (this.status) {
                case 2: {
                    return;
                }
                case 3: {
                    throw new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.prepare, reason: the transaction already is aborted", this.config.familyName));
                }
                case 4: {
                    throw new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.prepare, reason: the transaction already is committed", this.config.familyName));
                }
            }
            throw new IllegalStateException();
        }
        if (this.abortOnly) {
            throw this.abortOnWriteConflict();
        }
        if (this.hasUpdates && this.config.readLockMode != 2) {
            boolean success;
            boolean bl = success = this.config.dirtyCheck ? this.doPrepareDirty() : this.doPrepareAll();
            if (!success) {
                throw this.abortOnWriteConflict();
            }
        }
        this.status = 2;
    }

    private boolean doPrepareAll() {
        int spinCount = this.config.spinCount;
        for (int k = 0; k < this.firstFreeIndex; ++k) {
            BetaTranlocal tranlocal = this.array[k];
            if (tranlocal.prepareAllUpdates(this.pool, this, spinCount)) continue;
            return false;
        }
        return true;
    }

    private boolean doPrepareDirty() {
        int spinCount = this.config.spinCount;
        for (int k = 0; k < this.firstFreeIndex; ++k) {
            BetaTranlocal tranlocal = this.array[k];
            if (tranlocal.prepareDirtyUpdates(this.pool, this, spinCount)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void retry() {
        if (this.status != 1) {
            throw this.abortOnFaultyStatusOfRetry();
        }
        if (!this.config.blockingAllowed) {
            throw this.abortOnNoBlockingAllowed();
        }
        if (this.firstFreeIndex == 0) {
            throw this.abortOnNoRetryPossible();
        }
        DefaultRetryLatch listener = this.pool.takeDefaultRetryLatch();
        if (listener == null) {
            listener = new DefaultRetryLatch();
        }
        try {
            long listenerEra = listener.getEra();
            boolean furtherRegistrationNeeded = true;
            boolean atLeastOneRegistration = false;
            for (int k = 0; k < this.firstFreeIndex; ++k) {
                BetaTranlocal tranlocal = this.array[k];
                BetaTransactionalObject owner = tranlocal.owner;
                if (furtherRegistrationNeeded) {
                    switch (owner.___registerChangeListener(listener, tranlocal, this.pool, listenerEra)) {
                        case 0: {
                            atLeastOneRegistration = true;
                            break;
                        }
                        case 1: {
                            furtherRegistrationNeeded = false;
                            atLeastOneRegistration = true;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                owner.___abort(this, tranlocal, this.pool);
                this.array[k] = null;
            }
            this.status = 3;
            if (!atLeastOneRegistration) {
                throw this.abortOnNoRetryPossible();
            }
            this.awaitUpdate(listener);
            throw Retry.INSTANCE;
        }
        catch (Throwable throwable) {
            this.pool.putDefaultRetryLatch(listener);
            throw throwable;
        }
    }

    @Override
    public final boolean softReset() {
        if (this.status == 1 || this.status == 2) {
            this.abort();
        }
        if (this.attempt >= this.config.getMaxRetries()) {
            return false;
        }
        this.status = 1;
        this.abortOnly = false;
        ++this.attempt;
        this.firstFreeIndex = 0;
        this.hasReads = false;
        this.hasUntrackedReads = false;
        this.hasUpdates = false;
        return true;
    }

    @Override
    public void hardReset() {
        if (this.status == 1 || this.status == 2) {
            this.abort();
        }
        this.status = 1;
        this.abortOnly = false;
        this.hasReads = false;
        this.hasUpdates = false;
        this.hasUntrackedReads = false;
        this.attempt = 1;
        this.firstFreeIndex = 0;
        this.remainingTimeoutNs = this.config.timeoutNs;
    }

    @Override
    public void init(BetaTransactionConfiguration transactionConfig) {
        if (transactionConfig == null) {
            this.abort();
            throw new NullPointerException();
        }
        if (this.status == 1 || this.status == 2) {
            this.abort();
        }
        this.config = transactionConfig;
        this.hardReset();
    }
}

