/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta.conflictcounters;

import java.util.concurrent.atomic.AtomicLong;
import org.multiverse.stms.beta.conflictcounters.LocalConflictCounter;
import org.multiverse.stms.beta.transactionalobjects.BetaTransactionalObject;

public final class GlobalConflictCounter {
    private final AtomicLong[] counters;
    private final long[] initArray;

    public GlobalConflictCounter() {
        this(1);
    }

    public GlobalConflictCounter(int length) {
        this.counters = new AtomicLong[length];
        this.initArray = new long[length];
        for (int k = 0; k < length; ++k) {
            this.counters[k] = new AtomicLong();
            this.initArray[k] = -1L;
        }
    }

    public void signalConflict(BetaTransactionalObject ref) {
        int index = this.counters.length == 1 ? 0 : this.getIndex(ref);
        AtomicLong counter = this.counters[index];
        long oldValue = counter.get();
        counter.compareAndSet(oldValue, oldValue + 1L);
    }

    private int getIndex(BetaTransactionalObject ref) {
        return 0;
    }

    public LocalConflictCounter createLocalConflictCounter() {
        return new LocalConflictCounter(this);
    }

    protected long[] getInitArray() {
        return this.initArray;
    }

    public int getLength() {
        return this.counters.length;
    }

    public long count() {
        long result = 0L;
        for (int k = 0; k < this.counters.length; ++k) {
            result += this.counters[k].get();
        }
        return result;
    }

    public long getConflictCount(int counter) {
        return this.counters[counter].get();
    }
}

