/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta;

import org.multiverse.api.BackoffPolicy;
import org.multiverse.api.ExponentialBackoffPolicy;
import org.multiverse.api.IsolationLevel;
import org.multiverse.api.PessimisticLockLevel;
import org.multiverse.api.PropagationLevel;
import org.multiverse.api.TraceLevel;

public class BetaStmConfiguration {
    public PropagationLevel propagationLevel = PropagationLevel.Requires;
    public IsolationLevel isolationLevel = IsolationLevel.Snapshot;
    public PessimisticLockLevel pessimisticLockLevel = PessimisticLockLevel.LockNone;
    public boolean blockingAllowed = true;
    public boolean interruptible = false;
    public long timeoutNs = Long.MAX_VALUE;
    public boolean readonly = false;
    public int spinCount = 16;
    public boolean dirtyCheck = true;
    public int minimalArrayTreeSize = 4;
    public boolean trackReads = true;
    public int maxRetries = 1000;
    public boolean speculativeConfigEnabled = true;
    public int maxArrayTransactionSize = 20;
    public BackoffPolicy backoffPolicy = ExponentialBackoffPolicy.MAX_100_MS;
    public TraceLevel traceLevel = TraceLevel.None;

    public void validate() {
        if (this.isolationLevel == null) {
            throw new IllegalStateException("isolationLevel can't be null");
        }
        if (this.isolationLevel.isWriteSkewAllowed() && !this.trackReads) {
            throw new IllegalStateException(String.format("isolation level '%s' can't be combined with readtracking is falsesince it is needed to prevent the writeskew problem", new Object[]{this.isolationLevel}));
        }
        if (this.blockingAllowed && !this.trackReads) {
            throw new IllegalStateException("blockingAllowed can't be true if trackReads is false");
        }
        if (this.spinCount < 0) {
            throw new IllegalStateException("spinCount can't be smaller than 0, but was " + this.spinCount);
        }
        if (this.pessimisticLockLevel == null) {
            throw new IllegalStateException("pessimisticLockLevel can't be null");
        }
        if (this.minimalArrayTreeSize < 0) {
            throw new IllegalStateException("minimalArrayTreeSize can't be smaller than 0, but was " + this.minimalArrayTreeSize);
        }
        if (this.maxRetries < 0) {
            throw new IllegalStateException("maxRetries can't be smaller than 0, but was " + this.maxRetries);
        }
        if (this.maxArrayTransactionSize < 2) {
            throw new IllegalStateException("maxArrayTransactionSize can't be smaller than 2, but was " + this.maxArrayTransactionSize);
        }
        if (this.backoffPolicy == null) {
            throw new IllegalStateException("backoffPolicy can't be null");
        }
        if (this.traceLevel == null) {
            throw new IllegalStateException("traceLevel can't be null");
        }
        if (this.propagationLevel == null) {
            throw new IllegalStateException("propagationLevel can't be null");
        }
    }
}

