/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.sensors;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.multiverse.api.TransactionConfiguration;

public final class TransactionSensor {
    private final AtomicLong startedCount = new AtomicLong();
    private final AtomicLong attemptCount = new AtomicLong();
    private final AtomicInteger maxTries = new AtomicInteger();
    private final AtomicLong completedCount = new AtomicLong();
    private final AtomicLong failedCount = new AtomicLong();
    private final TransactionConfiguration configuration;

    public TransactionSensor(TransactionConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.configuration = configuration;
    }

    public void signalExecution(int attempts, boolean success) {
        int max;
        this.startedCount.incrementAndGet();
        this.attemptCount.addAndGet(attempts);
        if (success) {
            this.completedCount.incrementAndGet();
        } else {
            this.failedCount.incrementAndGet();
        }
        while (attempts > (max = this.maxTries.get()) && !this.maxTries.compareAndSet(max, attempts)) {
        }
    }

    public String toString() {
        double avgRetriesPerTransaction = (double)this.attemptCount.get() / (1.0 * (double)this.startedCount.get());
        return String.format("[%s] started=%s completed=%s failed=%s attempts=%s avg-retries=%.2f max-retries=%s", this.configuration.getFamilyName(), this.startedCount.get(), this.completedCount.get(), this.failedCount.get(), this.attemptCount.get(), avgRetriesPerTransaction, this.maxTries);
    }
}

