/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api;

import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.TransactionRequiredException;
import org.multiverse.stms.beta.transactions.BetaTransactionPool;

public final class ThreadLocalTransaction {
    public static final ThreadLocal<Container> threadlocal = new ThreadLocal<Container>(){

        @Override
        protected Container initialValue() {
            return new Container();
        }
    };

    public static Transaction getThreadLocalTransaction() {
        return ThreadLocalTransaction.threadlocal.get().transaction;
    }

    public static Container getThreadLocalTransactionContainer() {
        return threadlocal.get();
    }

    public static Transaction getRequiredThreadLocalTransaction() {
        Transaction tx = ThreadLocalTransaction.threadlocal.get().transaction;
        if (tx == null) {
            throw new TransactionRequiredException("No transaction is found on the ThreadLocalTransaction");
        }
        return tx;
    }

    public static void clearThreadLocalTransaction() {
        ThreadLocalTransaction.threadlocal.get().transaction = null;
    }

    public static void setThreadLocalTransaction(Transaction tx) {
        ThreadLocalTransaction.threadlocal.get().transaction = tx;
    }

    private ThreadLocalTransaction() {
    }

    public static class Container {
        public Transaction transaction;
        public BetaTransactionPool transactionPool = new BetaTransactionPool();
    }
}

