/*
 * Decompiled with CFR 0.152.
 */
package org.mule.wsdl.parser;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.sf.saxon.jaxp.SaxonTransformerFactory;
import org.jetbrains.annotations.NotNull;
import org.mule.metadata.xml.api.SchemaCollector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0012\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/mule/wsdl/parser/WsdlSchemasCollector;", "", "definition", "Ljavax/wsdl/Definition;", "charset", "", "(Ljavax/wsdl/Definition;Ljava/lang/String;)V", "foundImports", "Ljava/util/ArrayList;", "schemas", "Ljava/util/HashMap;", "Ljavax/wsdl/extensions/schema/Schema;", "Lkotlin/collections/HashMap;", "addImportedSchemas", "", "schema", "addIncludedSchemas", "addSchema", "key", "collectFromTypes", "types", "Ljavax/wsdl/Types;", "collectIfImport", "import", "collectSchemas", "collector", "Lorg/mule/metadata/xml/api/SchemaCollector;", "nodeToString", "node", "Lorg/w3c/dom/Node;", "toInMemorySchemaMap", "", "mule-wsdl-parser"})
public final class WsdlSchemasCollector {
    @NotNull
    private final Definition definition;
    @NotNull
    private final String charset;
    @NotNull
    private final HashMap<String, Schema> schemas;
    @NotNull
    private final ArrayList<String> foundImports;

    public WsdlSchemasCollector(@NotNull Definition definition, @NotNull String charset) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.definition = definition;
        this.charset = charset;
        this.schemas = new HashMap();
        this.foundImports = new ArrayList();
    }

    public /* synthetic */ WsdlSchemasCollector(Definition definition, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "UTF-8";
        }
        this(definition, string);
    }

    @NotNull
    public final SchemaCollector collector() {
        Object object;
        SchemaCollector schemaCollector;
        try {
            schemaCollector = SchemaCollector.getInstance((String)this.charset);
            Intrinsics.checkNotNullExpressionValue((Object)schemaCollector, (String)"{\n      SchemaCollector.getInstance(charset)\n    }");
        }
        catch (NoSuchMethodError e) {
            object = SchemaCollector.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n      SchemaCollector.getInstance()\n    }");
            schemaCollector = object;
        }
        SchemaCollector collector = schemaCollector;
        this.collectSchemas(this.definition);
        Map $this$forEach$iv = this.schemas;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$uri$schema = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$uri$schema;
            boolean bl3 = false;
            String uri = (String)entry.getKey();
            Object object2 = $dstr$uri$schema;
            boolean bl4 = false;
            Schema schema = (Schema)object2.getValue();
            try {
                object2 = schema.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"schema.element");
                collector.addSchema(uri, this.nodeToString((Node)object2));
            }
            catch (Exception e) {
                String schema2 = StringsKt.endsWith$default((String)uri, (String)".wsdl", (boolean)false, (int)2, null) ? "Schema embedded in wsdl" : "Schema";
                throw new IllegalArgumentException(schema2 + " [" + uri + "] could not be parsed", e);
            }
        }
        return collector;
    }

    private final void collectSchemas(Definition definition) {
        this.collectFromTypes(definition.getTypes());
        Iterable $this$forEach$iv = definition.getImports().values();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object t = element$iv = iterator.next();
            boolean bl = false;
            if (t instanceof Vector) {
                Iterable $this$forEach$iv2 = (Iterable)t;
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv2.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv2;
                    Object it = element$iv2 = iterator2.next();
                    boolean bl2 = false;
                    this.collectIfImport(it);
                }
                continue;
            }
            this.collectIfImport(t);
        }
    }

    private final void collectIfImport(Object object) {
        if (object instanceof Import && !this.foundImports.contains(((Import)object).getLocationURI())) {
            this.foundImports.add(((Import)object).getLocationURI());
            Definition definition = ((Import)object).getDefinition();
            Intrinsics.checkNotNullExpressionValue((Object)definition, (String)"import.definition");
            this.collectSchemas(definition);
        }
    }

    private final void collectFromTypes(Types types) {
        List list;
        Types types2 = types;
        if (types2 != null && (list = types2.getExtensibilityElements()) != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object element = element$iv = iterator.next();
                boolean bl = false;
                if (!(element instanceof Schema)) continue;
                this.addSchema(Intrinsics.stringPlus((String)((Schema)element).getDocumentBaseURI(), (Object)element.hashCode()), (Schema)element);
            }
        }
    }

    private final void addSchema(String key, Schema schema) {
        if (!this.schemas.containsKey(key)) {
            this.schemas.put(key, schema);
            this.addImportedSchemas(schema);
            this.addIncludedSchemas(schema);
        }
    }

    private final void addImportedSchemas(Schema schema) {
        Collection imports = schema.getImports().values();
        Iterable $this$forEach$iv = imports;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object vector = element$iv = iterator.next();
            boolean bl = false;
            if (!(vector instanceof Vector)) continue;
            Iterable $this$forEach$iv2 = (Iterable)vector;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                Schema importedSchema;
                Object element$iv2;
                Object element = element$iv2 = iterator2.next();
                boolean bl2 = false;
                if (!(element instanceof SchemaImport) || (importedSchema = ((SchemaImport)element).getReferencedSchema()) == null) continue;
                String string = importedSchema.getDocumentBaseURI();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"importedSchema.documentBaseURI");
                this.addSchema(string, importedSchema);
            }
        }
    }

    private final void addIncludedSchemas(Schema schema) {
        List list = schema.getIncludes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"schema.includes");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object include = element$iv = iterator.next();
            boolean bl = false;
            if (!(include instanceof SchemaReference)) continue;
            Schema referencedSchema = ((SchemaReference)include).getReferencedSchema();
            String string = referencedSchema.getDocumentBaseURI();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"referencedSchema.documentBaseURI");
            Intrinsics.checkNotNullExpressionValue((Object)referencedSchema, (String)"referencedSchema");
            this.addSchema(string, referencedSchema);
        }
    }

    private final String nodeToString(Node node) {
        try {
            StringWriter writer = new StringWriter();
            DOMSource source = new DOMSource(node);
            StreamResult result = new StreamResult(writer);
            SaxonTransformerFactory factory = new SaxonTransformerFactory();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            String string = writer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.toString()");
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Error transforming node to String", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> toInMemorySchemaMap() {
        void $this$mapValuesTo$iv$iv;
        this.collectSchemas(this.definition);
        Map $this$mapValues$iv = this.schemas;
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void entry;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            Element element = ((Schema)entry.getValue()).getElement();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"entry.value.element");
            String string = this.nodeToString(element);
            map3.put(k2, string);
        }
        return destination$iv$iv;
    }
}

