/*
 * Decompiled with CFR 0.152.
 */
package org.mule.wsdl.parser;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.sf.saxon.jaxp.SaxonTransformerFactory;
import org.jetbrains.annotations.NotNull;
import org.mule.metadata.xml.api.SchemaCollector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0012\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/mule/wsdl/parser/WsdlSchemasCollector;", "", "definition", "Ljavax/wsdl/Definition;", "charset", "", "(Ljavax/wsdl/Definition;Ljava/lang/String;)V", "foundImports", "Ljava/util/ArrayList;", "schemas", "Ljava/util/HashMap;", "Ljavax/wsdl/extensions/schema/Schema;", "Lkotlin/collections/HashMap;", "addImportedSchemas", "", "schema", "addIncludedSchemas", "addSchema", "key", "collectFromTypes", "types", "Ljavax/wsdl/Types;", "collectIfImport", "import", "collectSchemas", "collector", "Lorg/mule/metadata/xml/api/SchemaCollector;", "nodeToString", "node", "Lorg/w3c/dom/Node;", "Companion", "mule-wsdl-parser"})
public final class WsdlSchemasCollector {
    private final HashMap<String, Schema> schemas;
    private final ArrayList<String> foundImports;
    private final Definition definition;
    private final String charset;
    @NotNull
    private static final String TARGET_NS = "targetNamespace";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final SchemaCollector collector() {
        Map $receiver$iv;
        SchemaCollector collector = SchemaCollector.getInstance((String)this.charset);
        this.collectSchemas(this.definition);
        Map map = $receiver$iv = (Map)this.schemas;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $uri_schema;
            Map.Entry entry = $uri_schema = (element$iv = iterator.next());
            String uri = (String)entry.getKey();
            entry = $uri_schema;
            Schema schema = (Schema)entry.getValue();
            try {
                Element element = schema.getElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"schema.element");
                collector.addSchema(uri, this.nodeToString(element));
            }
            catch (Exception e) {
                String schema2 = StringsKt.endsWith$default((String)uri, (String)".wsdl", (boolean)false, (int)2, null) ? "Schema embedded in wsdl" : "Schema";
                throw (Throwable)new IllegalArgumentException(schema2 + " [" + uri + "] could not be parsed", e);
            }
        }
        SchemaCollector schemaCollector = collector;
        Intrinsics.checkExpressionValueIsNotNull((Object)schemaCollector, (String)"collector");
        return schemaCollector;
    }

    private final void collectSchemas(Definition definition) {
        this.collectFromTypes(definition.getTypes());
        Iterable $receiver$iv = definition.getImports().values();
        for (Object element$iv : $receiver$iv) {
            Object t = element$iv;
            if (t instanceof Vector) {
                Iterable $receiver$iv2 = (Iterable)t;
                Iterator iterator = $receiver$iv2.iterator();
                while (iterator.hasNext()) {
                    Object element$iv2;
                    Object it = element$iv2 = iterator.next();
                    this.collectIfImport(it);
                }
                continue;
            }
            this.collectIfImport(t);
        }
    }

    private final void collectIfImport(Object object) {
        if (object instanceof Import && !this.foundImports.contains(((Import)object).getLocationURI())) {
            this.foundImports.add(((Import)object).getLocationURI());
            Definition definition = ((Import)object).getDefinition();
            Intrinsics.checkExpressionValueIsNotNull((Object)definition, (String)"import.definition");
            this.collectSchemas(definition);
        }
    }

    private final void collectFromTypes(Types types) {
        Object object = types;
        if (object != null && (object = object.getExtensibilityElements()) != null) {
            Iterable $receiver$iv = (Iterable)object;
            for (Object element$iv : $receiver$iv) {
                Object element = element$iv;
                if (!(element instanceof Schema)) continue;
                String string = ((Schema)element).getElement().getAttribute(Companion.getTARGET_NS());
                if (string == null) {
                    String string2 = ((Schema)element).getDocumentBaseURI();
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.documentBaseURI");
                }
                this.addSchema(string, (Schema)element);
            }
        }
    }

    private final void addSchema(String key, Schema schema) {
        if (!this.schemas.containsKey(key)) {
            this.schemas.put(key, schema);
            this.addImportedSchemas(schema);
            this.addIncludedSchemas(schema);
        }
    }

    private final void addImportedSchemas(Schema schema) {
        Collection imports = schema.getImports().values();
        Iterable $receiver$iv = imports;
        for (Object element$iv : $receiver$iv) {
            Object vector = element$iv;
            if (!(vector instanceof Vector)) continue;
            Iterable $receiver$iv2 = (Iterable)vector;
            for (Object element$iv2 : $receiver$iv2) {
                Schema importedSchema;
                Object element = element$iv2;
                if (!(element instanceof SchemaImport) || (importedSchema = ((SchemaImport)element).getReferencedSchema()) == null) continue;
                String string = importedSchema.getDocumentBaseURI();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"importedSchema.documentBaseURI");
                this.addSchema(string, importedSchema);
            }
        }
    }

    private final void addIncludedSchemas(Schema schema) {
        Iterable $receiver$iv = schema.getIncludes();
        for (Object element$iv : $receiver$iv) {
            Object include = element$iv;
            if (!(include instanceof SchemaReference)) continue;
            Schema referencedSchema = ((SchemaReference)include).getReferencedSchema();
            String string = referencedSchema.getDocumentBaseURI();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"referencedSchema.documentBaseURI");
            Schema schema2 = referencedSchema;
            Intrinsics.checkExpressionValueIsNotNull((Object)schema2, (String)"referencedSchema");
            this.addSchema(string, schema2);
        }
    }

    private final String nodeToString(Node node) {
        try {
            StringWriter writer = new StringWriter();
            DOMSource source = new DOMSource(node);
            StreamResult result = new StreamResult(writer);
            SaxonTransformerFactory factory = new SaxonTransformerFactory();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            String string = writer.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"writer.toString()");
            return string;
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException("Error transforming node to String", e);
        }
    }

    public WsdlSchemasCollector(@NotNull Definition definition, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull((Object)definition, (String)"definition");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        this.definition = definition;
        this.charset = charset;
        this.schemas = new HashMap();
        this.foundImports = new ArrayList();
    }

    public /* synthetic */ WsdlSchemasCollector(Definition definition, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "UTF-8";
        }
        this(definition, string);
    }

    static {
        TARGET_NS = TARGET_NS;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/mule/wsdl/parser/WsdlSchemasCollector$Companion;", "", "()V", "TARGET_NS", "", "getTARGET_NS", "()Ljava/lang/String;", "mule-wsdl-parser"})
    public static final class Companion {
        @NotNull
        public final String getTARGET_NS() {
            return TARGET_NS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

