%dw 2.0

/**
* Represents a start/end time meassurement
*/
type TimeMessurement<T> =  {start: DateTime, result: T, end: DateTime}

/**
* Represents a time taken by a function call
*/
type DurationMessurement<T> = {time: Number, result: T}

/**
* Returns the current time in milliseconds
*/
fun currentMilliseconds(): Number =
    toMilliseconds(now())


/**
* Returns the representation of the specified DateTime in milliseconds
*/
fun toMilliseconds(date:DateTime): Number =
    date as Number {unit: "milliseconds"}

/**
* Executes the function and returns an object with the taken time in milliseconds with the result of the function
*/
fun duration<T>(valueToMesssure: ()-> T): DurationMessurement<T> = do {
    var timeResult = time(valueToMesssure)
    ---
    {
        time: toMilliseconds(timeResult.end) - toMilliseconds(timeResult.start),
        result: timeResult.result
    }
}

/**
* Executes the specified function and returns an object with the start time and end time with the result of the function
*/
fun time<T>(valueToMesssure: ()-> T): TimeMessurement<T> = do {
    var statTime = now()
    var result = valueToMesssure()
    var endTime = now()
    ---
    {
        start: statTime,
        result: result,
        end: endTime
    }

}

