package org.mule.weave.v2.api.tooling.expression

import org.mule.weave.v2.api.tooling.location.Location

/**
  * Expression models a DW mapping with predefined input an output types
  * and captures the information in which the two are related so that
  * it eases the development of visual representations for dw scripts.
  */
trait Expression {
  /**
    * The path to the type node of the output that corresponds to this expression
    */
  val outputPath: String

  /**
    *
    * @return the location of the ast node being mapped by the expression
    */
  def location: Location
}
