package org.mule.weave.v2.interpreted.node.structure.header.directives

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.ModuleNode
import org.mule.weave.v2.interpreted.node.NameSlot

class ImportDirective(val variable: NameSlot, val module: ModuleNode) extends Directive {
  override def productElement(n: Int): Any = {
    n match {
      case 0 => variable
    }
  }

  override def execute(implicit executionContext: ExecutionContext): Unit = {
    executionContext.executionStack().setModule(variable.slot, module.execute(executionContext))
  }

  override def productArity: Int = 1
}
