/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.editor.refactor;

import org.mule.weave.v2.editor.CodeRefactor;
import org.mule.weave.v2.editor.RefactorParameter;
import org.mule.weave.v2.editor.WeaveTextDocument;
import org.mule.weave.v2.parser.location.WeaveLocation;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%4Aa\u0003\u0007\u00013!AA\u0005\u0001B\u0001B\u0003%Q\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003&\u0011!I\u0003A!A!\u0002\u0013Q\u0003\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u0011Y\u0002!\u0011!Q\u0001\n)B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005q!)A\t\u0001C\u0001\u000b\")q\n\u0001C!!\")q\u000b\u0001C!1\n9R\t\u001f;sC\u000e$h+\u0019:jC\ndWMU3gC\u000e$xN\u001d\u0006\u0003\u001b9\t\u0001B]3gC\u000e$xN\u001d\u0006\u0003\u001fA\ta!\u001a3ji>\u0014(BA\t\u0013\u0003\t1(G\u0003\u0002\u0014)\u0005)q/Z1wK*\u0011QCF\u0001\u0005[VdWMC\u0001\u0018\u0003\ry'oZ\u0002\u0001'\r\u0001!\u0004\t\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005\u0012S\"\u0001\b\n\u0005\rr!\u0001D\"pI\u0016\u0014VMZ1di>\u0014\u0018aC5oiJ|G-^2f\t>\u0004\"a\u0007\u0014\n\u0005\u001db\"a\u0002\"p_2,\u0017M\\\u0001\u0010S:\u001cXM\u001d;TKB\f'/\u0019;pe\u0006\tR\r\u001f;sC\u000e$X\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013\u0001\u00037pG\u0006$\u0018n\u001c8\u000b\u0005=\u0002\u0012A\u00029beN,'/\u0003\u00022Y\tiq+Z1wK2{7-\u0019;j_:\fQ\u0002\u001d7bG\u0016$v.\u00138tKJ$\bCA\u000e5\u0013\t)DDA\u0002J]R\fQa]2pa\u0016\f1\u0002Z3gCVdGOT1nKB\u0011\u0011\b\u0011\b\u0003uy\u0002\"a\u000f\u000f\u000e\u0003qR!!\u0010\r\u0002\rq\u0012xn\u001c;?\u0013\tyD$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0003\n\u0013aa\u0015;sS:<'BA \u001d\u00035!\u0017N]3di&4XmS5oI\u00061A(\u001b8jiz\"\u0002B\u0012%J\u0015.cUJ\u0014\t\u0003\u000f\u0002i\u0011\u0001\u0004\u0005\u0006I!\u0001\r!\n\u0005\u0006Q!\u0001\r!\n\u0005\u0006S!\u0001\rA\u000b\u0005\u0006e!\u0001\ra\r\u0005\u0006m!\u0001\rA\u000b\u0005\u0006o!\u0001\r\u0001\u000f\u0005\u0006\u0007\"\u0001\r\u0001O\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cH#A)\u0011\u0007m\u0011F+\u0003\u0002T9\t)\u0011I\u001d:bsB\u0011\u0011%V\u0005\u0003-:\u0011\u0011CU3gC\u000e$xN\u001d)be\u0006lW\r^3s\u0003\r\u0011XO\u001c\u000b\u00043r\u000b\u0007CA\u000e[\u0013\tYFD\u0001\u0003V]&$\b\"B/\u000b\u0001\u0004q\u0016\u0001\u00033pGVlWM\u001c;\u0011\u0005\u0005z\u0016B\u00011\u000f\u0005E9V-\u0019<f)\u0016DH\u000fR8dk6,g\u000e\u001e\u0005\u0006E*\u0001\raY\u0001\nCJ<W/\\3oiN\u0004B!\u000f39M&\u0011QM\u0011\u0002\u0004\u001b\u0006\u0004\bCA\u000eh\u0013\tAGDA\u0002B]f\u0004")
public class ExtractVariableRefactor
implements CodeRefactor {
    private final boolean introduceDo;
    private final boolean insertSeparator;
    private final WeaveLocation extractExpression;
    private final int placeToInsert;
    private final WeaveLocation scope;
    private final String defaultName;
    private final String directiveKind;

    @Override
    public RefactorParameter[] parameters() {
        return (RefactorParameter[])((Object[])new RefactorParameter[]{new RefactorParameter("variableName", this.defaultName, "Variable Name")});
    }

    @Override
    public void run(WeaveTextDocument document, Map<String, Object> arguments) {
        String variableName = arguments.apply((Object)"variableName").toString();
        if (this.introduceDo) {
            document.insert("\n}", this.scope.endPosition().index());
            String expressionText = document.text(this.extractExpression.startPosition().index(), this.extractExpression.endPosition().index());
            document.replace(this.extractExpression.startPosition().index(), this.extractExpression.endPosition().index(), variableName);
            String newExpression = new StringBuilder(16).append("do {\n\t").append(this.directiveKind).append(" ").append(variableName).append(" = ").append(expressionText).append("\n\t---\n").toString();
            document.insert(newExpression, this.placeToInsert);
        } else {
            String expressionText = document.text(this.extractExpression.startPosition().index(), this.extractExpression.endPosition().index());
            document.replace(this.extractExpression.startPosition().index(), this.extractExpression.endPosition().index(), variableName);
            String newExpression = new StringBuilder(6).append("\n").append(this.directiveKind).append(" ").append(variableName).append(" = ").append(expressionText).append("\n").toString();
            if (this.insertSeparator) {
                newExpression = new StringBuilder(4).append(newExpression).append("---\n").toString();
            }
            document.insert(newExpression, this.placeToInsert);
        }
    }

    public ExtractVariableRefactor(boolean introduceDo, boolean insertSeparator, WeaveLocation extractExpression, int placeToInsert, WeaveLocation scope, String defaultName, String directiveKind) {
        this.introduceDo = introduceDo;
        this.insertSeparator = insertSeparator;
        this.extractExpression = extractExpression;
        this.placeToInsert = placeToInsert;
        this.scope = scope;
        this.defaultName = defaultName;
        this.directiveKind = directiveKind;
    }
}

