/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.sdk;

import java.util.regex.Pattern;
import org.mule.weave.v2.grammar.Identifiers$;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.utils.WeaveFile$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.StringOps;

public final class NameIdentifierHelper$ {
    public static NameIdentifierHelper$ MODULE$;
    private final String fileSeparator;
    private final Pattern VALID_IDENTIFIER_PATTERN;

    static {
        new NameIdentifierHelper$();
    }

    public String extensionOf(NameIdentifier name) {
        if (name.loader().isEmpty()) {
            return WeaveFile$.MODULE$.fileExtension();
        }
        return new StringBuilder(1).append(".").append(((String)name.loader().get()).toLowerCase()).toString();
    }

    public String fileSeparator() {
        return this.fileSeparator;
    }

    public String toWeaveFilePath(NameIdentifier name) {
        return this.toWeaveFilePath(name, this.fileSeparator());
    }

    public String toWeaveFilePath(NameIdentifier name, String fileSeparator) {
        return this.toWeaveFilePath(name, fileSeparator, this.extensionOf(name));
    }

    public String toWeaveBinaryFilePath(NameIdentifier name) {
        return this.toWeaveFilePath(name, this.fileSeparator(), WeaveFile$.MODULE$.binaryFileExtension());
    }

    public String toWeaveBinaryFilePath(NameIdentifier name, String fileSeparator) {
        return this.toWeaveFilePath(name, fileSeparator, WeaveFile$.MODULE$.binaryFileExtension());
    }

    public String toWeaveFilePath(NameIdentifier name, String fileSeparator, String extension) {
        return new StringBuilder(0).append(fileSeparator).append(name.name().replace("::", fileSeparator)).append(extension).toString();
    }

    public NameIdentifier fromWeaveFilePath(String name) {
        return this.fromWeaveFilePath(name, this.fileSeparator());
    }

    public NameIdentifier fromWeaveFilePath(String name, String filePath) {
        String path = name;
        Option<String> mayBeExtension = this.getExtension(name);
        if (mayBeExtension.isDefined()) {
            path = path.substring(0, name.length() - ((String)mayBeExtension.get()).length());
        }
        if (path.startsWith(filePath)) {
            path = path.substring(1);
        }
        if (mayBeExtension.isDefined()) {
            Object object = mayBeExtension.get();
            String string = WeaveFile$.MODULE$.fileExtension();
            if (!(object != null ? !object.equals(string) : string != null)) {
                return new NameIdentifier(path.replace(filePath, "::"), NameIdentifier$.MODULE$.apply$default$2());
            }
        }
        return new NameIdentifier(path.replace(filePath, "::"), (Option<String>)mayBeExtension.map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.substring(1)));
    }

    private Option<String> getExtension(String name) {
        if (name.lastIndexOf(46) >= 0) {
            return new Some(new StringOps(Predef$.MODULE$.augmentString(name)).drop(name.lastIndexOf(46)));
        }
        return None$.MODULE$;
    }

    public Pattern VALID_IDENTIFIER_PATTERN() {
        return this.VALID_IDENTIFIER_PATTERN;
    }

    public boolean isValidIdentifier(String name) {
        return this.VALID_IDENTIFIER_PATTERN().matcher(name).matches() && !Identifiers$.MODULE$.keywords().contains((Object)name);
    }

    private NameIdentifierHelper$() {
        MODULE$ = this;
        this.fileSeparator = System.getProperty("file.separator");
        this.VALID_IDENTIFIER_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$");
    }
}

