/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.sdk;

import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.BinaryWeaveResource;
import org.mule.weave.v2.sdk.ClassLoaderWeaveResourceResolver$;
import org.mule.weave.v2.sdk.DefaultWeaveResource;
import org.mule.weave.v2.sdk.NameIdentifierHelper$;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResource$;
import org.mule.weave.v2.sdk.WeaveResourceFactory$;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.mule.weave.v2.utils.WeaveConstants$;
import org.mule.weave.v2.utils.WeaveFile$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001\u0002\f\u0018\u0001\tB\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\u0006\u000b\u0002!\tA\u0012\u0005\u0006\u0013\u0002!\tE\u0013\u0005\u0006;\u0002!\tE\u0018\u0005\u0006I\u0002!\t%\u001a\u0005\u0006a\u0002!\t%\u001d\u0005\u0006g\u0002!I\u0001\u001e\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001bAq!a\u0005\u0001\t\u0003\n)\u0002C\u0004\u0002\u001c\u0001!\t!!\b\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$\u001d9\u0011QF\f\t\u0002\u0005=bA\u0002\f\u0018\u0011\u0003\t\t\u0004\u0003\u0004F\u001d\u0011\u0005\u00111\u0007\u0005\n\u0003kq!\u0019!C\u0001\u0003oA\u0001\"!\u0010\u000fA\u0003%\u0011\u0011\b\u0005\b\u0003\u007fqA\u0011AA!\u0011\u001d\t\u0019E\u0004C\u0001\u0003\u0003Bq!!\u0012\u000f\t\u0003\t\t\u0005C\u0004\u0002H9!\t!!\u0013\u0003A\rc\u0017m]:M_\u0006$WM],fCZ,'+Z:pkJ\u001cWMU3t_24XM\u001d\u0006\u00031e\t1a\u001d3l\u0015\tQ2$\u0001\u0002we)\u0011A$H\u0001\u0006o\u0016\fg/\u001a\u0006\u0003=}\tA!\\;mK*\t\u0001%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007C\u0001\u0016,\u001b\u00059\u0012B\u0001\u0017\u0018\u0005U9V-\u0019<f%\u0016\u001cx.\u001e:dKJ+7o\u001c7wKJ\fAb\u00197bgNdw.\u00193feN\u00042aL\u001c;\u001d\t\u0001TG\u0004\u00022i5\t!G\u0003\u00024C\u00051AH]8pizJ\u0011AJ\u0005\u0003m\u0015\nq\u0001]1dW\u0006<W-\u0003\u00029s\t\u00191+Z9\u000b\u0005Y*\u0003c\u0001\u0013<{%\u0011A(\n\u0002\n\rVt7\r^5p]B\u0002\"AP\"\u000e\u0003}R!\u0001Q!\u0002\t1\fgn\u001a\u0006\u0002\u0005\u0006!!.\u0019<b\u0013\t!uHA\u0006DY\u0006\u001c8\u000fT8bI\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0002H\u0011B\u0011!\u0006\u0001\u0005\u0006[\t\u0001\rAL\u0001\be\u0016\u001cx\u000e\u001c<f)\tY\u0015\u000bE\u0002%\u0019:K!!T\u0013\u0003\r=\u0003H/[8o!\tQs*\u0003\u0002Q/\tiq+Z1wKJ+7o\\;sG\u0016DQAU\u0002A\u0002M\u000bAA\\1nKB\u0011AkW\u0007\u0002+*\u0011akV\u0001\nm\u0006\u0014\u0018.\u00192mKNT!\u0001W-\u0002\u0007\u0005\u001cHO\u0003\u0002[3\u00051\u0001/\u0019:tKJL!\u0001X+\u0003\u001d9\u000bW.Z%eK:$\u0018NZ5fe\u0006i!/Z:pYZ,')\u001b8bef$\"aX2\u0011\u0007\u0011b\u0005\r\u0005\u0002+C&\u0011!m\u0006\u0002\u0014\u0005&t\u0017M]=XK\u00064XMU3t_V\u00148-\u001a\u0005\u0006%\u0012\u0001\raU\u0001\fe\u0016\u001cx\u000e\u001c<f!\u0006$\b\u000e\u0006\u0002LM\")q-\u0002a\u0001Q\u0006!\u0001/\u0019;i!\tIWN\u0004\u0002kWB\u0011\u0011'J\u0005\u0003Y\u0016\na\u0001\u0015:fI\u00164\u0017B\u00018p\u0005\u0019\u0019FO]5oO*\u0011A.J\u0001\u0012e\u0016\u001cx\u000e\u001c<f\u0005&t\u0017M]=QCRDGCA0s\u0011\u00159g\u00011\u0001i\u0003U!xnV3bm\u0016\u001cv.\u001e:dKJ+7o\\;sG\u0016$\"!\u001e=\u0011\u0005)2\u0018BA<\u0018\u0005Q!UMZ1vYR<V-\u0019<f%\u0016\u001cx.\u001e:dK\")\u0011p\u0002a\u0001u\u00069Q\r\\3nK:$\bCA>\u007f\u001b\u0005a(BA?B\u0003\rqW\r^\u0005\u0003\u007fr\u00141!\u0016*M\u0003U!xnV3bm\u0016\u0014\u0015N\\1ssJ+7o\\;sG\u0016$R\u0001YA\u0003\u0003\u000fAQ!\u001f\u0005A\u0002iDa!!\u0003\t\u0001\u0004q\u0015aE:pkJ\u001cWmV3bm\u0016\u0014Vm]8ve\u000e,\u0017A\u0003:fg>dg/Z+sYR!\u0011qBA\t!\r!CJ\u001f\u0005\u0006O&\u0001\r\u0001[\u0001\u000be\u0016\u001cx\u000e\u001c<f\u00032dG\u0003BA\f\u00033\u00012aL\u001cO\u0011\u0015\u0011&\u00021\u0001T\u0003=awn\\6vaJ+7o\\;sG\u0016\u001cH\u0003BA\f\u0003?AQaZ\u0006A\u0002!\f!cY1o%\u0016\u001cx\u000e\u001c<f%\u0016\u001cx.\u001e:dKR!\u0011QEA\u0016!\r!\u0013qE\u0005\u0004\u0003S)#a\u0002\"p_2,\u0017M\u001c\u0005\u0006%2\u0001\raU\u0001!\u00072\f7o\u001d'pC\u0012,'oV3bm\u0016\u0014Vm]8ve\u000e,'+Z:pYZ,'\u000f\u0005\u0002+\u001dM\u0011ab\t\u000b\u0003\u0003_\ta\u0002U!U\u0011~\u001bV\tU!S\u0003R{%+\u0006\u0002\u0002:A\u0019a(a\u000f\n\u00059|\u0014a\u0004)B)\"{6+\u0012)B%\u0006#vJ\u0015\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0003\u001d\u000bAC\\8D_:$X\r\u001f;DY\u0006\u001c8\u000f\\8bI\u0016\u0014\u0018AF2p]R,\u0007\u0010^\"mCN\u001cHn\\1eKJ|e\u000e\\=\u0002'A\u0014xN^5eK\u0012\u001cE.Y:t\u0019>\fG-\u001a:\u0015\u0007\u001d\u000bY\u0005C\u0004\u0002NU\u0001\r!a\u0014\u0002\u0019\rd\u0017m]:M_\u0006$WM]:\u0011\u0007=:T\b")
public class ClassLoaderWeaveResourceResolver
implements WeaveResourceResolver {
    private final Seq<Function0<ClassLoader>> classloaders;

    public static ClassLoaderWeaveResourceResolver providedClassLoader(Seq<ClassLoader> seq) {
        return ClassLoaderWeaveResourceResolver$.MODULE$.providedClassLoader(seq);
    }

    public static ClassLoaderWeaveResourceResolver contextClassloaderOnly() {
        return ClassLoaderWeaveResourceResolver$.MODULE$.contextClassloaderOnly();
    }

    public static ClassLoaderWeaveResourceResolver noContextClassloader() {
        return ClassLoaderWeaveResourceResolver$.MODULE$.noContextClassloader();
    }

    public static ClassLoaderWeaveResourceResolver apply() {
        return ClassLoaderWeaveResourceResolver$.MODULE$.apply();
    }

    public static String PATH_SEPARATOR() {
        return ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR();
    }

    @Override
    public Option<WeaveResource> resolve(NameIdentifier name) {
        String path = NameIdentifierHelper$.MODULE$.toWeaveFilePath(name, ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR());
        return this.resolvePath(path);
    }

    @Override
    public Option<BinaryWeaveResource> resolveBinary(NameIdentifier name) {
        String path = NameIdentifierHelper$.MODULE$.toWeaveBinaryFilePath(name, ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR());
        return this.resolveBinaryPath(path);
    }

    @Override
    public Option<WeaveResource> resolvePath(String path) {
        return this.resolveUrl(path).map((Function1 & Serializable & scala.Serializable)url -> this.toWeaveSourceResource((URL)url));
    }

    @Override
    public Option<BinaryWeaveResource> resolveBinaryPath(String path) {
        Option maybeSourceWeaveResource = this.resolveUrl(path.replace(WeaveFile$.MODULE$.binaryFileExtension(), WeaveFile$.MODULE$.fileExtension())).map((Function1 & Serializable & scala.Serializable)url -> this.toWeaveSourceResource((URL)url));
        return maybeSourceWeaveResource.flatMap((Function1 & Serializable & scala.Serializable)sourceWeaveResource -> this.resolveUrl(path).map((Function1 & Serializable & scala.Serializable)url -> this.toWeaveBinaryResource((URL)url, (WeaveResource)sourceWeaveResource)));
    }

    private DefaultWeaveResource toWeaveSourceResource(URL element) {
        DefaultWeaveResource defaultWeaveResource;
        try (BufferedSource source = Source$.MODULE$.fromInputStream(element.openStream(), WeaveConstants$.MODULE$.default_encoding());){
            defaultWeaveResource = WeaveResource$.MODULE$.apply(element.toExternalForm(), source.mkString());
        }
        return defaultWeaveResource;
    }

    private BinaryWeaveResource toWeaveBinaryResource(URL element, WeaveResource sourceWeaveResource) {
        return WeaveResourceFactory$.MODULE$.fromBinaryInputStream(element.openStream(), sourceWeaveResource);
    }

    public Option<URL> resolveUrl(String path) {
        String string = NameIdentifierHelper$.MODULE$.fileSeparator();
        String string2 = ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR();
        String cannonicalPath = (string == null ? string2 != null : !string.equals(string2)) ? path.replace(NameIdentifierHelper$.MODULE$.fileSeparator(), ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR()) : path;
        String weaveFilePath = cannonicalPath.startsWith(ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR()) ? cannonicalPath.substring(1) : cannonicalPath;
        Enumeration<Object> resources = Collections.emptyEnumeration();
        Iterator classLoadersIt = this.classloaders.toIterator();
        while (classLoadersIt.hasNext() && !resources.hasMoreElements()) {
            ClassLoader classLoader = (ClassLoader)((Function0)classLoadersIt.next()).apply();
            resources = classLoader.getResources(weaveFilePath);
        }
        if (resources.hasMoreElements()) {
            return Option$.MODULE$.apply(resources.nextElement());
        }
        return None$.MODULE$;
    }

    @Override
    public Seq<WeaveResource> resolveAll(NameIdentifier name) {
        String path = NameIdentifierHelper$.MODULE$.toWeaveFilePath(name, ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR());
        return this.lookupResources(path);
    }

    public Seq<WeaveResource> lookupResources(String path) {
        String weaveFilePath = path.startsWith(ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR()) ? path.substring(1) : path;
        Enumeration<Object> resources = Collections.emptyEnumeration();
        Iterator classLoadersIt = this.classloaders.toIterator();
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (classLoadersIt.hasNext()) {
            ClassLoader classLoader = (ClassLoader)((Function0)classLoadersIt.next()).apply();
            resources = classLoader.getResources(weaveFilePath);
            result.$plus$plus$eq((TraversableOnce)((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(resources).asScala()).map((Function1 & Serializable & scala.Serializable)resource -> {
                DefaultWeaveResource defaultWeaveResource;
                try (BufferedSource source = Source$.MODULE$.fromInputStream(resource.openStream(), "UTF-8");){
                    defaultWeaveResource = WeaveResource$.MODULE$.apply(resource.toExternalForm(), source.mkString());
                }
                return defaultWeaveResource;
            }));
        }
        return result;
    }

    @Override
    public boolean canResolveResource(NameIdentifier name) {
        String path = NameIdentifierHelper$.MODULE$.toWeaveFilePath(name, ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR());
        return this.resolveUrl(path).isDefined();
    }

    public ClassLoaderWeaveResourceResolver(Seq<Function0<ClassLoader>> classloaders) {
        this.classloaders = classloaders;
        WeaveResourceResolver.$init$(this);
    }
}

