package org.mule.weave.v2.utils

/**
  * An utility class that support concurrent lazy initialization and cleaning.
  * The difference from lazy keywords from scala are:
  * 1. It allows to unset the value
  * 2. It allows to specify the value initializer on get
  * @param valueResolver The value resolver if global
  * @tparam V The type of the value ref
  */
class LazyValRef[V <: AnyRef](valueResolver: Option[() => V]) {

  private var innerValue: Option[V] = None

  def get(): V = {
    if (innerValue.isEmpty) {
      this.synchronized({
        if (innerValue.isEmpty) {
          val valueProvider = valueResolver.get
          innerValue = Some(valueProvider())
        }
      })
    }

    innerValue.get
  }

  def get(valueResolver: () => V): V = {
    if (innerValue.isEmpty) {
      this.synchronized({
        if (innerValue.isEmpty) {
          innerValue = Some(valueResolver())
        }
      })
    }
    innerValue.get
  }

  def clean(): Unit = {
    this.synchronized({
      innerValue = None
    })
  }

}

object LazyValRef {
  def apply[V <: AnyRef](valueResolver: () => V): LazyValRef[V] = {
    new LazyValRef[V](Some(valueResolver))
  }

  def apply[V <: AnyRef](): LazyValRef[V] = {
    new LazyValRef[V](None)
  }
}
