package org.mule.weave.v2.utils

trait BasicCache[KeyType, ValueType] {

  def remove(path: KeyType): Option[ValueType]

  def get(key: KeyType): ValueType

  def clear(): Unit

  def getIfPresent(key: KeyType): Option[ValueType]

  def get(key: KeyType, resolver: (KeyType) => ValueType): ValueType

  def values(): Iterator[ValueType]

  def keys(): Iterator[KeyType]
}

/**
  * Trait used to mark values that need to be disposed. The dispose method is going to be called when it is removed from the cache
  */
trait Disposable {
  def dispose()
}