package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

import scala.collection.Seq

object PatternMatcherTypeResolver extends WeaveTypeResolver {
  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val weaveTypes: Seq[WeaveType] = node.incomingEdges().filter(_.incomingTypeDefined()).map(_.incomingType())
    Some(TypeHelper.unify(weaveTypes))
  }

  override def supportsPartialResolution(): Boolean = true
}
