package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.ts.Edge
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

import scala.collection.Seq

class PassThroughWithDocs(documentation: Option[String]) extends WeaveTypeResolver {
  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {

    node.incomingEdges() match {
      case Seq(x) => {
        val weaveType = x.incomingType()
        weaveType.withDocumentation(documentation, weaveType.location())
        Some(weaveType)
      }
      case _ => {
        if (ctx.currentParsingContext.strictMode) {
          throw new RuntimeException(s"PassThrough resolver only works with nodes with one edge but found '${node.incomingEdges().size}' with node ${node.astNode} at ${node.astNode.location().locationString}.")
        } else {
          None
        }
      }
    }
  }

  override def resolveExpectedType(node: TypeNode, incomingExpectedType: Option[WeaveType], ctx: WeaveTypeResolutionContext): Seq[(Edge, WeaveType)] = {
    if (incomingExpectedType.isDefined) {
      node.incomingEdges().map((_, incomingExpectedType.get))
    } else {
      Seq()
    }
  }
}
