package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.ts.Edge
import org.mule.weave.v2.ts.EdgeLabels
import org.mule.weave.v2.ts.FunctionType
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

import scala.collection.Seq

object LiteralPatternTypeResolver extends WeaveTypeResolver {
  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val caseExpression: Edge = node.incomingEdges(EdgeLabels.CASE_EXPRESSION).head
    val matchExpression: Edge = node.incomingEdges(EdgeLabels.MATCH_EXPRESSION).head
    val functionType: FunctionType = matchExpression.incomingType().asInstanceOf[FunctionType]
    FunctionCallNodeResolver.resolveReturnType(functionType, Seq(caseExpression.incomingType()), Seq(), node, ctx)
  }
}
