package org.mule.weave.v2.ts

import org.mule.weave.v2.parser.InvalidReferenceMessage
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.scope.Reference
import org.mule.weave.v2.ts.resolvers.RetyperResolver

import scala.collection.mutable

class WrappedResolver(resolver: ReferenceResolver, condition: TypeNode, branch: Boolean) extends ReferenceResolver {
  private val retyperNodes: mutable.Map[Reference, TypeNode] = mutable.Map()

  override def resolveVariable(typeGraphBuilder: TypeGraphBuilder, node: NameIdentifier, result: TypeNode, label: Option[EdgeLabel]): Unit = {
    val parsingContext = typeGraphBuilder.parsingContext

    parsingContext.notificationManager.progress()
    typeGraphBuilder.scope.resolveVariable(node) match {
      case Some(ref) =>
        val newResult: TypeNode = retyperNodes.getOrElseUpdate(
          ref, {

          val toInsert = typeGraphBuilder.createNode(node, RetyperResolver(branch, ref))
          Edge(condition, toInsert, Some(EdgeLabels.BRANCH_CONSTRAINT))
          resolver.resolveVariable(typeGraphBuilder, node, toInsert, Some(EdgeLabels.ORIGINAL_TYPE))
          toInsert
        })

        Edge(newResult, result, label)

      case None =>
        val message = InvalidReferenceMessage(node)

        parsingContext.messageCollector.error(message, node.location())
    }
  }

  override def cleanResolver(): ReferenceResolver = new WrappedResolver(resolver.cleanResolver(), condition, branch)
}
