package org.mule.weave.v2.sdk.selectors

import org.mule.weave.v2.ts.AnyType
import org.mule.weave.v2.ts.ArrayType
import org.mule.weave.v2.ts.KeyType
import org.mule.weave.v2.ts.NameType
import org.mule.weave.v2.ts.ObjectType
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.TypeHelper.unify
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext

object MultiValueSelectorCustomTypeResolver extends BaseValueSelectorCustomTypeResolver {

  /**
    * MultiValue selector flattens on Array selection (org.mule.weave.v2.runtime.core.operator.selectors.ArrayMultiValueSelectorOperator)
    */
  override protected def resolveSelectionOverArray(nameType: WeaveType, ctx: WeaveTypeResolutionContext, node: TypeNode, of: WeaveType): SelectionResult = {
    val result = resolve(of, nameType, ctx, node, insideArray = true)
    result match {
      case NoMatch(closed) => {
        if (closed) {
          NoMatch(closed)
        } else {
          Matched(ArrayType(AnyType()).markOptional())
        }
      }
      case Unknown => Unknown
      case Matched(weaveType) => {
        Matched(weaveType)
      }
    }
  }

  override def select(leftType: WeaveType, selector: WeaveType, ctx: WeaveTypeResolutionContext, node: TypeNode, insideArray: Boolean): SelectionResult = {
    val maybeNameType: Option[NameType] = getSelectorNameType(selector)
    if (maybeNameType.isEmpty) {
      Unknown
    } else {
      val name = maybeNameType.get
      leftType match {
        case ObjectType(properties, closed, _) => {
          name.value match {
            case Some(_) => {
              properties
                .find((prop) => {
                  prop.key match {
                    case keyType: KeyType => TypeHelper.canBeAssignedTo(keyType.name, name, ctx)
                    case _                => false
                  }
                })
                .map((prop) => {
                  Matched(
                    ArrayType(prop.value)
                      .withOptional(prop.optional))
                })
                .getOrElse(NoMatch(closed))
            }
            case None => {
              if (properties.size == 1) {
                properties.headOption
                  .map((kvp) => {
                    val value: WeaveType = kvp.value.markOptional()
                    Matched(ArrayType(value))
                  })
                  .getOrElse(NoMatch(false))
              } else {
                //In case all values are of the same type such as a Dictionary of String we can output String otherwise we don't do anything :(
                //
                val weaveType: WeaveType = unify(properties.map(_.value)).markOptional()
                Matched(weaveType)
              }
            }
          }
        }
        case _ => Unknown
      }
    }

  }
}
