package org.mule.weave.v2.sdk.selectors

import org.mule.weave.v2.ts.AnyType
import org.mule.weave.v2.ts.ArrayType
import org.mule.weave.v2.ts.CustomTypeResolver
import org.mule.weave.v2.ts.IntersectionType
import org.mule.weave.v2.ts.ObjectType
import org.mule.weave.v2.ts.RecursionDetector
import org.mule.weave.v2.ts.ReferenceType
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.UnionType
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext

object DescendantsSelectorTypeResolver extends CustomTypeResolver {
  override def resolve(invocationTypes: Seq[WeaveType], ctx: WeaveTypeResolutionContext, node: TypeNode, resolvedReturnType: WeaveType): Option[WeaveType] = {
    val types = descendants(invocationTypes.head)
    if (types.isEmpty) {
      Some(ArrayType(AnyType()))
    } else {
      Some(ArrayType(TypeHelper.unify(types)))
    }
  }

  def descendants(weaveType: WeaveType, recursionDetector: RecursionDetector[Seq[WeaveType]] = RecursionDetector.apply((_, _) => Seq())): Seq[WeaveType] = {
    weaveType match {
      case ObjectType(keyValuePairTypes, _, _) => {
        keyValuePairTypes.map(_.value) ++ keyValuePairTypes.flatMap((kvp) => descendants(kvp.value, recursionDetector))
      }
      case rt: ReferenceType => {
        recursionDetector.resolve(rt, (resolvedType) => descendants(resolvedType, recursionDetector))
      }
      case IntersectionType(of) => {
        TypeHelper.resolveIntersection(of) match {
          case IntersectionType(it) => {
            it ++ of.flatMap((t) => descendants(t, recursionDetector))
          }
          case wt => descendants(wt, recursionDetector)
        }
      }
      case ArrayType(of) => Seq(of) ++ descendants(of, recursionDetector)
      case UnionType(of) => of ++ of.flatMap((t) => descendants(t, recursionDetector))
      case _             => Seq()
    }
  }
}
