package org.mule.weave.v2.scaffolding

import org.mule.weave.v2.ts.WeaveType

/**
  * Filter what parts of a data structure is going to be scaffold.
  */
trait ScaffoldingFilter {

  /**
    * If returns true then the element is going to be scaffold
    * @param elementPath The path of where this value is located
    * @param value The value to be scaffold
    * @return True if this value needs to be scaffold false if it needs to be skipped
    */
  def accepts(elementPath: WeaveTypePath, value: WeaveType): Boolean
}

/**
  * Impl that doesn't filter
  */
object NoScaffoldingFilter extends ScaffoldingFilter {
  override def accepts(elementPath: WeaveTypePath, value: WeaveType): Boolean = true
}
