package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.InvalidWeaveVersion
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.header.directives.{ DirectiveNode, VersionDirective }
import org.mule.weave.v2.parser.ast.module.ModuleNode
import org.mule.weave.v2.parser.ast.structure.DocumentNode
import org.mule.weave.v2.utils.DataWeaveVersion

class VersionCheckerPhase[T <: AstNode] extends CompilationPhase[ParsingResult[T], ParsingResult[T]] {
  override def doCall(source: ParsingResult[T], context: ParsingContext): PhaseResult[_ <: ParsingResult[T]] = {
    val directives: Seq[DirectiveNode] = source.astNode match {
      case m: ModuleNode   => m.elements
      case d: DocumentNode => d.header.directives
      case _               => Seq[DirectiveNode]()
    }
    val maybeVersionDirective = directives.find(dn => dn.isInstanceOf[VersionDirective]).asInstanceOf[Option[VersionDirective]]
    if (maybeVersionDirective.isDefined) {
      val versionDirective = maybeVersionDirective.get
      val majorVersion: Int = versionDirective.major.v.toInt
      val minorVersion: Int = versionDirective.minor.v.toInt
      val runtimeVersion = VersionCheckerPhase.getWeaveVersion

      if (majorVersion != runtimeVersion.major || minorVersion > runtimeVersion.minor) {
        context.messageCollector.error(InvalidWeaveVersion(
          s"${runtimeVersion.major}.${runtimeVersion.minor}",
          s"$majorVersion.$minorVersion"), versionDirective.location())
        FailureResult(context)
      } else {
        SuccessResult(source, context)
      }
    } else {
      SuccessResult(source, context)
    }
  }

}

object VersionCheckerPhase extends VersionCheckerPhase {
  lazy val getWeaveVersion: DataWeaveVersion = DataWeaveVersion()
}
