package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.api.tooling.internal.DefaultDWAstNode
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.scope.AstNavigator
import org.mule.weave.v2.scope.ScopesNavigator

class TypeAnnotationProcessingPhase[R <: AstNode, T <: TypeCheckingResult[R]]() extends FullCompileOnlyPhase[R, T] {

  override def run(source: T, context: ParsingContext): Unit = {
    if (context.hasTypePhaseAnnotationProcessors) {
      val astNavigator = AstNavigator(source.astNode)
      val annotationNodes = AstNodeHelper.collectChildrenWith(source.astNode, classOf[AnnotationNode])
      if (annotationNodes.nonEmpty) {
        val navigator: ScopesNavigator = source.scope
        annotationNodes.foreach(f = (annotationNode) => {
          val annotatedNode = astNavigator.parentOf(annotationNode)
          val maybeRef = navigator.resolveVariable(annotationNode.name)
          if (maybeRef.isDefined) {
            val annotationRef = maybeRef.get
            val nameIdentifier = annotationRef.fqnReferenceName
            context.typePhaseAnnotationProcessorFor(nameIdentifier) match {
              case Some(ap) => ap.run(DefaultDWAstNode(annotatedNode.get, astNavigator, Some(source.typeGraph), Some(navigator)), DefaultDWAstNode(annotationNode, astNavigator, Some(source.typeGraph), Some(navigator)), new DefaultAnnotationContext(context))
              case _        =>
            }
          }
        })
      }
    }
  }

}
