package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.api.tooling.internal.DefaultDWAstNode
import org.mule.weave.v2.parser.annotation.PreCompiledTypeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.scope.AstNavigator

class ParsingAnnotationProcessorPhase[R <: AstNode, T <: AstNodeResultAware[R]]() extends FullCompileOnlyPhase[R, T] {

  override def run(source: T, context: ParsingContext): Unit = {
    if (context.hasParsingPhaseAnnotationProcessors) {
      val astNavigator = AstNavigator(source.astNode)
      val annotationNodes = AstNodeHelper.collectChildrenWith(source.astNode, classOf[AnnotationNode])
      if (annotationNodes.nonEmpty) {
        annotationNodes.foreach(f = (annotationNode) => {
          val annotatedNode = astNavigator.parentOf(annotationNode)
          val nameIdentifier = annotationNode.name
          context.parsingPhaseAnnotationProcessorFor(nameIdentifier) match {
            case Some(ap) => ap.run(DefaultDWAstNode(annotatedNode.get, astNavigator, None, None), DefaultDWAstNode(annotationNode, astNavigator, None, None), new DefaultAnnotationContext(context))
            case _        =>
          }
        })
      }
    }
  }

}
