package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.MissingRequiredAnnotationArgument
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNodeHelper

class InterceptorValidatorAnnotationProcessor extends AbstractScopeAnnotationProcessor {

  override def run(annotatedNode: AstNode, annotation: AnnotationNode, context: ScopePhaseAnnotationContext): Unit = {
    val maybeInterceptorFunction = AnnotationNodeHelper.arg("interceptorFunction", annotation)
    if (maybeInterceptorFunction.isEmpty) {
      context.messageCollector.error(MissingRequiredAnnotationArgument("interceptorFunction"), annotation.location())
    }
  }
}
