package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.VariableNameClashedWithImplicitInputMessage
import org.mule.weave.v2.parser.annotation.InjectedNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.header.directives.ContentType
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode
import org.mule.weave.v2.parser.ast.header.directives.InputDirective
import org.mule.weave.v2.parser.ast.header.directives.NamespaceDirective
import org.mule.weave.v2.parser.ast.header.directives.TypeDirective
import org.mule.weave.v2.parser.ast.header.directives.VarDirective
import org.mule.weave.v2.parser.ast.structure.DocumentNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.module.MimeType

class ImplicitInputsTransformer extends AstNodeTransformer {
  override def transform(node: AstNode, context: ParsingContext): Unit = {
    node match {
      case DocumentNode(header, _) =>
        val variablesByName = groupVariablesByNames(header.directives)
        context.implicitInput.foreach((implicitInputData) => {
          val alreadyDefined = header.directives //
            .collect({ case inputDirective: InputDirective => inputDirective })
            .exists(id => {
              id.variable.name.equals(implicitInputData.name)
            })
          if (!alreadyDefined) {
            val maybeVariable = variablesByName.get(implicitInputData.name)
            if (!context.settings.removeShadowedImplicitInputs || maybeVariable.isEmpty) {
              val mimeType = implicitInputData.mimeType.map(_.toStringWithoutParameters).getOrElse(MimeType.INTERNAL_MIME_TYPE)
              val directive: InputDirective = InputDirective(NameIdentifier(implicitInputData.name), ContentType(mimeType), None, None)
              directive.annotate(InjectedNodeAnnotation())
              directive.variable.annotate(InjectedNodeAnnotation())
              header.directives = directive +: header.directives
            } else {
              val nodes = maybeVariable.get
              nodes.foreach(n => context.messageCollector.warning(VariableNameClashedWithImplicitInputMessage(implicitInputData.name), n.location()))
            }
          }
        })
      case _ =>
    }
  }

  private def groupVariablesByNames(directives: Seq[DirectiveNode]): Map[String, Seq[AstNode]] = {
    directives
      .collect({
        case vd: VarDirective       => vd
        case vd: NamespaceDirective => vd
        case vd: TypeDirective      => vd
        case vd: InputDirective     => vd
      })
      .groupBy({
        case vd: VarDirective       => vd.variable.name
        case vd: NamespaceDirective => vd.prefix.name
        case vd: TypeDirective      => vd.variable.name
        case vd: InputDirective     => vd.variable.name
      })
  }
}
