package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.ErrorAstNode
import org.mule.weave.v2.parser.ast.AstNode

class ErrorsNodeValidation extends AstNodeVerifier {

  override def verify(node: AstNode, context: ParsingContext): Unit = {
    node match {
      case en: ErrorAstNode => {
        context.messageCollector.error(en.message(), en.location())
      }
      case _ =>
    }
  }
}
