package org.mule.weave.v2.parser.ast.structure

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.{ AstNode, Children, MutableAstNode }

case class KeyValuePairNode(var key: AstNode, var value: AstNode, var cond: Option[AstNode] = None) extends AstNode with MutableAstNode {
  override def children(): Seq[AstNode] = Children(key, value).+=(cond).result()

  override protected def doClone(): AstNode = {
    copy(key.cloneAst(), value.cloneAst(), cond.map(_.cloneAst()))
  }

  override def update(toBeReplaced: AstNode, withNode: AstNode): Unit = {
    if (key eq toBeReplaced) {
      key = withNode
    } else if (value eq toBeReplaced) {
      value = withNode
    } else if (cond.exists(_ eq toBeReplaced)) {
      cond = Some(withNode)
    }
  }

  override def getKind(): String = DWAstNodeKind.KEY_VALUE_PAIR_NODE
}
