package org.mule.weave.v2.parser.ast.structure

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Children
import org.mule.weave.v2.parser.ast.annotation.AnnotationCapableNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode

case class KeyNode(var keyName: AstNode, var ns: Option[AstNode] = None, var attr: Option[AstNode] = None, var codeAnnotations: Seq[AnnotationNode] = Seq()) extends AnnotationCapableNode {

  override def children(): Seq[AstNode] = Children(keyName).+=(ns).+=(attr).++=(codeAnnotations).result()

  override protected def doClone(): AstNode = {
    copy(keyName.cloneAst(), ns.map(_.cloneAst()), attr.map(_.cloneAst()), codeAnnotations.map(_.cloneAst()))
  }

  /**
    * Sets the annotations to this node
    *
    * @param annotations The list of annotations
    */
  override def setAnnotations(annotations: Seq[AnnotationNode]): Unit = {
    this.codeAnnotations = annotations
  }

  override def getKind(): String = DWAstNodeKind.KEY_NODE
}

object KeyNode {
  def apply(keyName: String): KeyNode = {
    KeyNode(QuotedStringNode(keyName))
  }
}
