package org.mule.weave.v2.parser.ast.structure

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Child

case class DynamicNameNode(var keyName: AstNode) extends AstNode {

  override def children(): Seq[AstNode] = Child(keyName)

  override protected def doClone(): AstNode = {
    copy(keyName.cloneAst())
  }

  override def getKind(): String = DWAstNodeKind.DYNAMIC_NAME_NODE
}