package org.mule.weave.v2.parser.ast.structure

import org.mule.weave.v2.annotations.WeaveApi
import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Child
import org.mule.weave.v2.parser.ast.DirectivesCapableNode
import org.mule.weave.v2.parser.ast.MutableAstNode
import org.mule.weave.v2.parser.ast.header.HeaderNode
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode

@WeaveApi(Seq("data-weave-agent"))
case class DocumentNode(var header: HeaderNode, var root: AstNode) extends AstNode with DirectivesCapableNode with MutableAstNode {
  override def children(): Seq[AstNode] = Child(header, root)

  override def directives: Seq[DirectiveNode] = header.directives
  override protected def doClone(): AstNode = copy(header.cloneAst(), root.cloneAst())

  override def update(toBeReplaced: AstNode, withNode: AstNode): Unit = {
    if (toBeReplaced eq header) {
      header = withNode.asInstanceOf[HeaderNode]
    } else if (toBeReplaced eq root) {
      root = withNode
    }
  }

  override def getKind(): String = DWAstNodeKind.DOCUMENT_NODE
}
