package org.mule.weave.v2.parser.ast.selectors

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Children
import org.mule.weave.v2.parser.ast.ContainerAstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode

case class NullUnSafeNode(selector: AstNode, var codeAnnotations: Seq[AnnotationNode] = Seq()) extends ContainerAstNode with SelectorAstNode {
  override def children(): Seq[AstNode] = Children(selector).++=(codeAnnotations).result()

  override protected def doClone(): AstNode = {
    copy(selector.cloneAst(), codeAnnotations.map(_.cloneAst()))
  }

  /**
    * Sets the annotations to this node
    *
    * @param annotations The list of annotations
    */
  override def setAnnotations(annotations: Seq[AnnotationNode]): Unit = {
    this.codeAnnotations = annotations
  }

  override def getKind(): String = DWAstNodeKind.NULL_UNSAFE_NODE
}
