package org.mule.weave.v2.parser.ast.selectors

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.MutableAstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Children
import org.mule.weave.v2.parser.ast.ContainerAstNode

case class NullSafeNode(var selector: AstNode, var codeAnnotations: Seq[AnnotationNode] = Seq()) extends ContainerAstNode with SelectorAstNode with MutableAstNode {

  override def children(): Seq[AstNode] = Children(selector).++=(codeAnnotations).result()

  override protected def doClone(): AstNode = {
    copy(selector.cloneAst(), codeAnnotations.map(_.cloneAst()))
  }

  override def update(toBeReplaced: AstNode, withNode: AstNode): Unit = {
    if (toBeReplaced eq selector) {
      selector = withNode
    }
  }

  /**
    * Sets the annotations to this node
    *
    * @param annotations The list of annotations
    */
  override def setAnnotations(annotations: Seq[AnnotationNode]): Unit = {
    this.codeAnnotations = annotations
  }

  override def getKind(): String = DWAstNodeKind.NULL_SAFE_NODE
}
