package org.mule.weave.v2.parser

import org.mule.weave.v2.parser.exception.LocatableException
import org.mule.weave.v2.parser.location.Location
import org.parboiled2._

case class SyntaxErrorException(override val location: Location, error: ParseError, input: ParserInput, msg: Option[String]) extends LocatableException {
  val formatter = new ErrorFormatter(showLine = false, showPosition = true)

  override def toString: String = msg.getOrElse(formatter.format(error, input))

  override def message: String = toString
}