package org.mule.weave.v2.inspector

import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.phase.ParsingContext

/**
  * The implementation of this trait will try to match this for a given inspection, that only requires the scope phase.
  * The inspector is going to be called for all the nodes in a AST Tree. So that the implementor of an inspector should only match on a given node with a given pattern
  */
trait CodeInspector[T] {

  /**
    * Runs the inspection
    * @param node The node where to be executed
    * @param scopeData The scope data
    * @param parsingContext The parsing context
    */
  def inspect(node: AstNode, scopeData: T, parsingContext: ParsingContext): Unit

}
