package org.mule.weave.v2.grammar

sealed trait OpIdentifier {
  val name: String
}

sealed class UnaryOpIdentifier(val name: String) extends OpIdentifier

object MinusOpId extends UnaryOpIdentifier("-")

object AllSchemaSelectorOpId extends UnaryOpIdentifier("All Schema Selector (.^)")

object NamespaceSelectorOpId extends UnaryOpIdentifier("Namespace Selector (.#)")

object DescendantsSelectorOpId extends UnaryOpIdentifier("Descendants Selector ..")

object NotOpId extends UnaryOpIdentifier("not")

object AllAttributesSelectorOpId extends UnaryOpIdentifier("All Attribute Selector (.@)")

sealed class BinaryOpIdentifier(val name: String) extends OpIdentifier

object AttributeValueSelectorOpId extends BinaryOpIdentifier("Attribute selector (.@)")

object MultiValueSelectorOpId extends BinaryOpIdentifier("MultiValue Selector (.*)")

object MultiAttributeValueSelectorOpId extends BinaryOpIdentifier(".*@")

object GreaterOrEqualThanOpId extends BinaryOpIdentifier(">=")

object AdditionOpId extends BinaryOpIdentifier("+")

object IsOpId extends BinaryOpIdentifier("is")

object SubtractionOpId extends BinaryOpIdentifier("-")

object DivisionOpId extends BinaryOpIdentifier("/")

object MultiplicationOpId extends BinaryOpIdentifier("*")

object RightShiftOpId extends BinaryOpIdentifier(">>")

object LeftShiftOpId extends BinaryOpIdentifier("<<")

object DynamicSelectorOpId extends BinaryOpIdentifier("Dynamic Selector")

object EqOpId extends BinaryOpIdentifier("==")

object NotEqOpId extends BinaryOpIdentifier("!=")

object GreaterThanOpId extends BinaryOpIdentifier(">")

object SchemaValueSelectorOpId extends BinaryOpIdentifier("Schema Value Selector (.^)")

object ValueSelectorOpId extends BinaryOpIdentifier("Value Selector")

object ObjectKeyValueSelectorOpId extends BinaryOpIdentifier("Object Key Filter (.&)")

object FilterSelectorOpId extends BinaryOpIdentifier("Filter Selector ([?()])")

object SimilarOpId extends BinaryOpIdentifier("~=")

object RangeSelectorOpId extends BinaryOpIdentifier("Range Selector")

object LessThanOpId extends BinaryOpIdentifier("<")

object LessOrEqualThanOpId extends BinaryOpIdentifier("<=")

object AsOpId extends BinaryOpIdentifier("as")

object MetadataInjectorOpId extends BinaryOpIdentifier("<~")

object MetadataAdditionOpId extends BinaryOpIdentifier("<+")
