package org.mule.weave.v2.grammar

import org.mule.weave.v2.grammar.location.PositionTracking
import org.mule.weave.v2.parser.InvalidNameIdentifierError
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.parboiled2.CharPredicate
import org.parboiled2.Parser
import org.parboiled2.Rule
import org.parboiled2.Rule1
import org.parboiled2.StringBuilding

trait Identifiers extends PositionTracking with Tokens with StringBuilding with WhiteSpaceHandling with ErrorRecovery {
  this: Identifiers with Parser =>

  def nameIdentifier: Rule1[String] = namedRule("Name Identifier") {
    clearSB() ~ validName() ~ push(sb.toString.trim)
  }

  def nameIdentifierNode: Rule1[NameIdentifier] = rule {
    pushPosition ~ nameIdentifier ~> createNameIdentifier ~ injectPosition
  }

  val createNameIdentifier: (String) => NameIdentifier = (name: String) => {
    NameIdentifier(name)
  }

  private def validName() = namedRule("Name Identifier") {
    validNameStartText ~ validNameTest ~ notAKeyword
  }

  private def validNameStartText = namedRule("[a-Z]") {
    atomic(++ | -- ~ !ch('-') | ValidStartName ~ appendSB())
  }

  private def validNameTest = namedRule("Alpha Numeric Character") {
    atomic(zeroOrMore(ValidNameChar ~ appendSB()))
  }

  def ++() = rule {
    str("++") ~ appendSB("++")
  }

  def --() = rule {
    str("--") ~ appendSB("--")
  }

  def notAKeyword = namedRule(s"Not being any of: ${Identifiers.keywords.mkString(", ")}") {
    !test(Identifiers.keywords.contains(sb.toString))
  }

  def fqnSeparator() = rule {
    str("::")
  }

  private def loader() = rule {
    optional(clearSB() ~ validName() ~ str("!") ~ push(sb.toString.trim))
  }

  def fullQualifiedNamePrefix() = rule {
    zeroOrMore(atomic(nameIdentifier ~ fqnSeparator()))
  }

  def fullQualifiedName = rule {
    loader() ~ fullQualifiedNamePrefix() ~ nameIdentifier
  }

}

object Identifiers {
  val keywords: Seq[String] = Seq(
    "if",
    "else",
    "unless",
    "using",
    "---",
    "as",
    "is",
    "null",
    "true",
    "false",
    "default",
    "case",
    "fun",
    "input",
    "output",
    "ns",
    "type",
    "import",
    "var",
    // "match",
    "and",
    "or",
    //    Add once we have syntax directive
    //    "annotation",
    //    "from",
    // added to avoid future conflicts and breaking changes, we can remove them later.
    // but we wanna ensure that we are no breaking something in the near future
    "throw",
    "do",
    "for",
    "yield",
    "enum",
    "private",
    "async")
}
