package org.mule.weave.v2.editor.quickfix

import org.mule.weave.v2.WeaveEditorSupport
import org.mule.weave.v2.completion.Template
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.types.TypeReferenceNode

class CreateTypeDeclarationQuickFix(val editorSupport: WeaveEditorSupport, trn: TypeReferenceNode, argName: String) extends TemplateBasedQuickFixAction {

  override protected def createTemplate(): Template = {
    val template = Template().add(s"type ${argName}")
    template.add(" = ")
    template.placeHolder("???")
    template.newLine()
    template
  }

  override val element: AstNode = trn
}