package org.mule.weave.v2.module.commons.java.writer

import org.mule.weave.v2.model.structure.QualifiedName
import org.mule.weave.v2.model.values.math.Number

import scala.util.matching.Regex

object JavaAdapter {
  def fromScalaToJava(value: Any): Any = {
    val javaValue = value match {
      case n: Number => {
        if (n.isWhole) {
          if (n.canBeInt) n.toInt
          else if (n.canBeLong) n.toLong
          else n.toBigInt.bigInteger
        } else {
          if (n.withinDouble) n.toDouble
          else n.toBigDecimal.bigDecimal
        }
      }
      case qn: QualifiedName => {
        qn.name
      }
      case cs: CharSequence => cs.toString
      case r: Regex         => r.pattern
      case _                => value
    }
    javaValue
  }
}
